/*
 * Decompiled with CFR 0.152.
 */
package game.states;

import game.core.MapData;
import game.core.Viewport;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.Weather;
import game.core.mechanics.character.BigGuard;
import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.CollisionManager;
import game.core.mechanics.collision.handlers.HandlerCitizenCharacter;
import game.core.mechanics.collision.handlers.HandlerDestructibleGameCharacter;
import game.core.mechanics.collision.handlers.HandlerDestructibleWeapon;
import game.core.mechanics.collision.handlers.HandlerHeroEnemy;
import game.core.mechanics.collision.handlers.HandlerHeroTrigger;
import game.core.mechanics.collision.handlers.HandlerMovable;
import game.core.mechanics.collision.handlers.HandlerMoveableHero;
import game.core.mechanics.collision.handlers.HandlerObjects;
import game.core.mechanics.collision.handlers.HandlerTriggerActivation;
import game.core.mechanics.collision.handlers.HandlerUsableHero;
import game.core.mechanics.collision.handlers.HandlerWeaponEnemy;
import game.core.mechanics.collision.handlers.HandlerWeaponHero;
import game.core.mechanics.dialog.Dialog;
import game.core.mechanics.objects.trigger.DoorTrigger;
import game.core.mechanics.objects.trigger.OwlTrigger;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public class GamePlay
extends BasicGameState {
    protected State currentState = State.Normal;
    private Music[] background = new Music[2];
    MapData mapData;
    ArrayList<IGameEntity> activeObjects = new ArrayList();
    ArrayList<IGameEntity> remover = new ArrayList();
    ArrayList<IGameEntity> adder = new ArrayList();
    Dialog currentDialog = null;
    private Weather weather = new Weather();
    private OwlTrigger currentOwl;
    private UnicodeFont font;
    private Color deathColor = new Color(1.0f, 0.0f, 0.0f, 0.3f);
    private Point2D.Float checkPoint;
    private static final int flightDuration = 2000;
    private String message;
    private int messageDuration = 0;
    private BigGuard boss;
    private Rectangle bossArea;
    Hero hero;
    private Viewport view;
    int checkX = 0;
    int checkY = 0;
    private int maxBlack = 800;
    private float currentBlack = 0.0f;
    Image gameOver;
    CollisionManager collisionManager;
    private boolean mapLoaded;
    private boolean displayEndMessage = false;

    public boolean isMapLoaded() {
        return this.mapLoaded;
    }

    public Hero getHero() {
        return this.hero;
    }

    public void startBossfight(BigGuard boss) {
        if (this.boss != null) {
            return;
        }
        this.currentState = State.Boss;
        this.updateMusic();
        this.boss = boss;
        this.currentDialog = boss.getBossDialog();
        this.currentDialog.start();
        this.currentState = State.Dialog;
        this.bossArea = boss.getNormalizedBossArea();
        this.view.followEntityInArea(this.hero, this.bossArea);
    }

    @Override
    public int getID() {
        return 1;
    }

    public MapData getMapData() {
        return this.mapData;
    }

    public CollisionManager getCollisionManager() {
        return this.collisionManager;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.hero = new Hero();
        this.hero.init(container, game);
        this.loadFont();
        this.view = new Viewport(this.hero);
        this.background[0] = new Music("data/sound/music/background.ogg", true);
        this.background[1] = new Music("data/sound/music/boss.ogg", true);
        this.gameOver = new Image("data/Menu/GameOver.png");
        this.weather.init();
    }

    @Override
    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.currentBlack = 0.0f;
        this.updateMusic();
    }

    @Override
    public void leave(GameContainer container, StateBasedGame game) throws SlickException {
        super.leave(container, game);
        if (this.background[0].playing()) {
            this.background[0].fade(500, 0.0f, true);
        } else {
            this.background[1].fade(500, 0.0f, true);
        }
    }

    public void displayMenu() {
        this.currentBlack = 1.0f;
        this.displayEndMessage = false;
    }

    public void loadMap(String mapLocation, GameContainer container, StateBasedGame game) throws SlickException {
        this.mapLoaded = false;
        System.out.println("Start Loading");
        this.mapData = new MapData();
        this.activeObjects = new ArrayList();
        System.gc();
        try {
            LinkedList<IGameEntity> newE = this.mapData.loadXmlMap(mapLocation);
            for (IGameEntity e : newE) {
                e.init(container, game);
            }
        }
        catch (IOException | ParserConfigurationException | DOMException | SAXException e) {
            e.printStackTrace();
            System.exit(e.hashCode());
        }
        this.collisionManager = new CollisionManager(this.mapData.getMap(), this.mapData.getCollisionLayer());
        this.collisionManager.addHandler(new HandlerHeroEnemy());
        this.collisionManager.addHandler(new HandlerWeaponEnemy());
        this.collisionManager.addHandler(new HandlerWeaponHero());
        this.collisionManager.addHandler(new HandlerDestructibleGameCharacter());
        this.collisionManager.addHandler(new HandlerDestructibleWeapon());
        this.collisionManager.addHandler(new HandlerMoveableHero());
        this.collisionManager.addHandler(new HandlerMovable());
        this.collisionManager.addHandler(new HandlerHeroTrigger());
        this.collisionManager.addHandler(new HandlerUsableHero());
        this.collisionManager.addHandler(new HandlerCitizenCharacter());
        this.collisionManager.addHandler(new HandlerTriggerActivation());
        this.collisionManager.addHandler(new HandlerObjects());
        this.hero.setPosition(new Point2D.Float(this.mapData.getHeroStart().x * 64 + 32, this.mapData.getHeroStart().y * 64 + 32));
        this.checkPoint = (Point2D.Float)this.hero.getPosition().clone();
        this.activeObjects.add(this.hero);
        this.collisionManager.addCollidable(this.hero);
        this.initActiveObjects(container, game);
        System.out.println("Loading Finished");
        this.updateMusic();
        this.mapLoaded = true;
    }

    private void initActiveObjects(GameContainer container, StateBasedGame game) throws SlickException {
        int newCheckX = (int)(this.hero.getPosition().x / 64.0f);
        int newCheckY = (int)(this.hero.getPosition().y / 64.0f);
        int checkArea = 14;
        int x = newCheckX - checkArea;
        while (x <= newCheckX + checkArea) {
            int y = newCheckY - checkArea;
            while (y <= newCheckY + checkArea) {
                IGameEntity e;
                if (x >= 0 && y >= 0 && x < this.mapData.getMap().getWidth() && y < this.mapData.getMap().getHeight() && (e = this.mapData.getEntities()[x][y]) != null && !this.activeObjects.contains(e)) {
                    this.activeObjects.add(e);
                    this.collisionManager.addCollidable(e);
                }
                ++y;
            }
            ++x;
        }
    }

    public void setCheckpoint() {
        this.checkPoint = (Point2D.Float)this.hero.getPosition().clone();
        this.displayMessage("Checkpoint reached", 1000);
    }

    public void startDialog(Dialog dialog) {
        this.hero.setAllowInput(false);
        this.currentDialog = dialog;
        dialog.start();
        this.currentState = State.Dialog;
    }

    public void addEntity(IGameEntity newE, int x, int y, GameContainer container, StateBasedGame game) throws SlickException {
        if (newE == null) {
            return;
        }
        newE.init(container, game);
        newE.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
        this.adder.add(newE);
    }

    private void loadFont() throws SlickException {
        this.font = new UnicodeFont("data/font/kratos.ttf", 48, false, false);
        this.font.addAsciiGlyphs();
        this.font.addGlyphs(400, 600);
        this.font.getEffects().add(new ColorEffect(java.awt.Color.WHITE));
        this.font.loadGlyphs();
    }

    public void startOwl(OwlTrigger owlTrigger) {
        if (this.currentState == State.Owl) {
            return;
        }
        this.hero.setAllowInput(false);
        this.hero.setCharState(GameCharacter.CharacterState.Standing);
        if (this.hero.getStepSound().playing()) {
            this.hero.getStepSound().stop();
        }
        this.currentOwl = owlTrigger;
        owlTrigger.prepareOwl(this.hero.getPosition());
        this.currentState = State.Owl;
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        int x = this.view.getIX();
        int y = this.view.getIY();
        int i = 0;
        while (i < this.mapData.getObjectLayer()) {
            this.mapData.getMap().render(x % 64 * -1, y % 64 * -1, x / 64, y / 64, 21, 13, i, false);
            ++i;
        }
        for (IGameEntity e : this.activeObjects) {
            e.draw(this.view.getX(), this.view.getY());
        }
        i = this.mapData.getObjectLayer();
        while (i < this.mapData.getMap().getLayerCount() - 1) {
            this.mapData.getMap().render(x % 64 * -1, y % 64 * -1, x / 64, y / 64, 21, 13, i, false);
            ++i;
        }
        this.weather.draw(x, y, g);
        switch (this.currentState) {
            case Dead: {
                g.setColor(this.deathColor);
                g.fillRect(0.0f, 0.0f, 1280.0f, 720.0f);
                break;
            }
            case Dialog: {
                this.hero.setCharState(GameCharacter.CharacterState.Standing);
                this.hero.getStepSound().stop();
                this.currentDialog.draw(g);
                break;
            }
            case Owl: {
                this.currentOwl.draw(x, y, g);
                break;
            }
        }
        this.hero.drawStats();
        if (this.messageDuration > 0) {
            g.setFont(this.font);
            g.setColor(Color.white);
            g.drawString(this.message, 640 - this.font.getWidth(this.message) / 2, 200.0f);
        }
        if (this.hero.getInventory().getKeys() > 1) {
            g.setColor(Color.yellow);
            g.drawString(String.valueOf(this.hero.getInventory().getKeys()), 180.0f, 85.0f);
        }
        if (this.currentBlack > 0.0f) {
            if (!this.displayEndMessage) {
                float b = this.currentBlack / (float)this.maxBlack;
                g.setColor(new Color(0.0f, 0.0f, 0.0f, b));
                g.fillRect(0.0f, 0.0f, 1280.0f, 720.0f);
            } else {
                this.gameOver.setAlpha(this.currentBlack / (float)this.maxBlack);
                this.gameOver.draw();
            }
        }
    }

    private void updateMusic() {
        if (!(this.background[0].playing() || this.background[1].playing() || this.weather.getCondition() == Weather.WeatherPhase.Rain || this.weather.isRainPlaying())) {
            if (this.currentState == State.Boss) {
                if (this.background[0].playing()) {
                    this.background[0].stop();
                }
                this.background[1].loop();
                this.background[1].setVolume(0.0f);
                this.background[1].fade(1000, 1.0f, false);
            } else {
                if (this.background[1].playing()) {
                    this.background[1].stop();
                }
                this.background[0].loop();
                this.background[0].setVolume(0.0f);
                this.background[0].fade(1000, 1.0f, false);
            }
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (delta > 100) {
            return;
        }
        this.view.update(delta);
        Input in = container.getInput();
        if (in.isKeyDown(1)) {
            this.displayMenu();
        }
        if (in.isKeyDown(48)) {
            this.hero.setPosition(new Point2D.Float(3136.0f, 2816.0f));
            this.initActiveObjects(container, game);
        }
        if (in.isKeyDown(49)) {
            this.hero.setPosition(new Point2D.Float(5376.0f, 8192.0f));
            this.initActiveObjects(container, game);
        }
        if (this.currentBlack > 0.0f) {
            this.currentBlack += (float)delta;
            if (this.currentBlack >= (float)this.maxBlack && !this.displayEndMessage) {
                game.enterState(0);
            }
            return;
        }
        if (this.messageDuration > 0) {
            this.messageDuration -= delta;
        }
        this.weather.update(delta);
        this.updateMusic();
        switch (this.currentState) {
            case Normal: {
                for (IGameEntity e : this.activeObjects) {
                    e.update(container, game, delta);
                }
                this.collisionManager.processCollisions();
                break;
            }
            case Dialog: {
                if (this.currentDialog.isFinished()) {
                    this.currentState = State.Normal;
                    this.hero.setAllowInput(true);
                    this.currentDialog = null;
                    if (this.boss != null) {
                        this.currentState = State.Boss;
                    }
                } else {
                    this.currentDialog.update(container.getInput(), delta);
                }
                return;
            }
            case Dead: {
                if (this.view.isPanning()) break;
                this.hero.revive();
                this.initActiveObjects(container, game);
                this.currentState = State.Normal;
                break;
            }
            case Owl: {
                this.currentOwl.updateOwlStatus(container, game, delta);
                if (this.currentOwl.isFinished()) {
                    this.currentState = State.Normal;
                    this.hero.setAllowInput(true);
                }
                return;
            }
            case Boss: {
                for (IGameEntity e : this.activeObjects) {
                    e.update(container, game, delta);
                }
                this.collisionManager.processCollisions();
                if (this.boss.getCharState() != GameCharacter.CharacterState.Dead) break;
                this.boss = null;
                this.bossArea = null;
                this.currentState = State.Normal;
                this.view.followEntity(this.hero);
                this.updateMusic();
                this.displayEndMessage = true;
                this.currentBlack = 1.0f;
            }
        }
        if (this.hero.getCharState() == GameCharacter.CharacterState.Dead && this.currentState != State.Dead) {
            this.updateDeath();
        }
        if (this.bossArea != null) {
            this.updateBossAreaCheck();
        }
        this.updateRemoval();
        this.updateNewEntities();
        this.updateActiveObjects(container, game);
        Collections.sort(this.activeObjects);
    }

    private void updateDeath() {
        if (this.boss != null) {
            this.removeEntity(this.boss);
            this.boss.resetBoss();
        }
        this.boss = null;
        this.bossArea = null;
        this.currentState = State.Dead;
        this.displayMessage("You died - reviving at checkpoint", 2000);
        this.view.panAndFollow(this.checkPoint.x - 640.0f, this.checkPoint.y - 360.0f, 2000, this.hero);
        this.hero.setPosition((Point2D.Float)this.checkPoint.clone());
    }

    public void displayMessage(String msg, int time) {
        this.message = msg;
        this.messageDuration = time;
    }

    private void updateBossAreaCheck() {
        this.checkBossArea(this.hero);
        this.checkBossArea(this.boss);
    }

    private void checkBossArea(IGameEntity ent) {
        if (ent.getPosition().x < this.bossArea.getMinX()) {
            ent.getPosition().x = this.bossArea.getMinX();
        } else if (ent.getPosition().x > this.bossArea.getMaxX()) {
            ent.getPosition().x = this.bossArea.getMaxX();
        }
        if (ent.getPosition().y < this.bossArea.getMinY()) {
            ent.getPosition().y = this.bossArea.getMinY();
        } else if (ent.getPosition().y > this.bossArea.getMaxY()) {
            ent.getPosition().y = this.bossArea.getMaxY();
        }
    }

    private void updateActiveObjects(GameContainer container, StateBasedGame game) throws SlickException {
        int newCheckX = (int)(this.hero.getPosition().x / 64.0f);
        int newCheckY = (int)(this.hero.getPosition().y / 64.0f);
        if (newCheckX == this.checkX && this.checkY == newCheckY) {
            return;
        }
        int column = -1;
        int row = -1;
        int checkArea = 14;
        if (newCheckX < this.checkX) {
            column = newCheckX - checkArea;
        } else if (newCheckX > this.checkX) {
            column = newCheckX + checkArea;
        }
        if (newCheckY < this.checkY) {
            row = newCheckY - checkArea;
        } else if (newCheckY > this.checkY) {
            row = newCheckY + checkArea;
        }
        this.checkX = newCheckX;
        this.checkY = newCheckY;
        if (column != -1) {
            int y = newCheckY - checkArea;
            while (y <= newCheckY + checkArea) {
                if (column >= 0 && y >= 0 && column < this.mapData.getMap().getWidth() && y < this.mapData.getMap().getHeight()) {
                    this.activeObjectHelper(this.mapData.getEntities()[column][y], column, y);
                }
                ++y;
            }
        }
        if (row != -1) {
            int x = newCheckX - checkArea;
            while (x <= newCheckX + checkArea) {
                if (x >= 0 && row >= 0 && x < this.mapData.getMap().getWidth() && row < this.mapData.getMap().getHeight()) {
                    this.activeObjectHelper(this.mapData.getEntities()[x][row], x, row);
                }
                ++x;
            }
        }
    }

    private void activeObjectHelper(IGameEntity e, int x, int y) {
        if (e != null && !this.activeObjects.contains(e)) {
            if (e instanceof DoorTrigger && ((DoorTrigger)e).getDoorType() == DoorTrigger.Type.Wood) {
                e.setPosition(new Point2D.Float(x * 64, y * 64 + 32));
            } else {
                e.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
            }
            this.collisionManager.addCollidable(e);
            this.activeObjects.add(e);
        }
    }

    public void removeEntity(IGameEntity entity) {
        this.remover.add(entity);
    }

    private void updateRemoval() {
        for (IGameEntity entity : this.remover) {
            this.activeObjects.remove(entity);
            this.collisionManager.removeCollidable(entity);
        }
        this.remover.clear();
    }

    private void updateNewEntities() {
        for (IGameEntity entity : this.adder) {
            this.activeObjects.add(entity);
            this.collisionManager.addCollidable(entity);
        }
        this.adder.clear();
    }

    public Viewport getViewport() {
        return this.view;
    }

    protected static enum State {
        Normal,
        Dead,
        Dialog,
        Owl,
        Boss;

    }
}

