/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects.trigger;

import game.core.mechanics.Direction;
import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.dialog.Dialog;
import game.core.mechanics.objects.Trigger;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.state.StateBasedGame;

public class OwlTrigger
extends Trigger {
    private int owlX;
    private int owlY;
    Dialog dialog;
    int dialogID = -1;
    public static Animation owlFlying;
    public static Image owl;
    private static final int owlHeight = 138;
    private static final int owlWidth = 234;
    private boolean activated = false;
    private boolean finished = true;
    private boolean soundUsed = false;
    private static float currentOwlDistance;
    private static Point2D.Float flyVector;
    private static float maxOwlDistance;
    private static Point2D.Float owlPos;
    private static final int flyTime = 3000;
    private static boolean owlLanded;

    static {
        currentOwlDistance = 0.0f;
        flyVector = new Point2D.Float();
        maxOwlDistance = 0.0f;
        owlPos = new Point2D.Float();
    }

    public OwlTrigger(Point2D.Float pos, boolean automatic, int dialogID, int owlX, int owlY) {
        super(pos, automatic);
        this.setDialogID(dialogID);
        this.owlX = owlX;
        this.owlY = owlY;
    }

    public void prepareOwl(Point2D.Float heroPos) {
        owlLanded = false;
        this.finished = false;
        int realX = this.owlX * 64 + 32;
        int realY = this.owlY * 64 + 32;
        float distX = (float)realX - heroPos.x;
        float distY = (float)realY - heroPos.y;
        OwlTrigger.owlPos.x = distX > 0.0f ? heroPos.x - 1480.0f : heroPos.x - 1480.0f;
        OwlTrigger.owlPos.y = distY > 0.0f ? heroPos.y - 920.0f : heroPos.y + 920.0f;
        maxOwlDistance = Math.abs((float)realX - OwlTrigger.owlPos.x) + Math.abs((float)realY - OwlTrigger.owlPos.y);
        currentOwlDistance = 0.0f;
        OwlTrigger.flyVector.x = ((float)realX - OwlTrigger.owlPos.x) / 3000.0f;
        OwlTrigger.flyVector.y = ((float)realY - OwlTrigger.owlPos.y) / 3000.0f;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        if (this.dialogID != -1) {
            Dialog.usedDialogs.remove((Object)dialog.getId());
        }
        if (dialog != null) {
            this.dialogID = dialog.getId();
            Dialog.usedDialogs.add(this.dialogID);
        } else {
            this.dialogID = -1;
        }
    }

    public void setOwlX(int owlX) {
        this.owlX = owlX;
    }

    public void setOwlY(int owlY) {
        this.owlY = owlY;
    }

    public int getOwlX() {
        return this.owlX;
    }

    public int getOwlY() {
        return this.owlY;
    }

    public int getDialogID() {
        return this.dialogID;
    }

    public void setDialogID(int dialogID) {
        if (this.dialogID != -1) {
            Dialog.usedDialogs.remove((Object)this.dialogID);
        }
        this.dialogID = dialogID;
        if (this.dialogID != -1) {
            Dialog.usedDialogs.add(this.dialogID);
        }
    }

    public Sound getSound() {
        return this.soundEffect;
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        if (this.currentState == Trigger.State.Active) {
            return false;
        }
        return this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape());
    }

    public void draw(float x, float y, Graphics g) {
        if (currentOwlDistance < maxOwlDistance || this.dialog.isFinished()) {
            owlFlying.draw(OwlTrigger.owlPos.x - x - (float)(owlFlying.getWidth() / 2), OwlTrigger.owlPos.y - y - (float)owlFlying.getHeight());
        } else if (!this.dialog.isFinished()) {
            owl.draw(OwlTrigger.owlPos.x - x - (float)(owl.getWidth() / 2), OwlTrigger.owlPos.y - y - (float)owl.getHeight());
            this.dialog.draw(g);
        }
    }

    public void updateOwlStatus(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (owlLanded && !this.getDialog().isFinished()) {
            this.getDialog().update(container.getInput(), delta);
            this.soundUsed = false;
        } else if (!owlLanded) {
            float factor = 3.0f * (1.0f - 0.98f * (currentOwlDistance / maxOwlDistance));
            OwlTrigger.owlPos.x += OwlTrigger.flyVector.x * factor * (float)delta;
            OwlTrigger.owlPos.y += OwlTrigger.flyVector.y * factor * (float)delta;
            currentOwlDistance += Math.abs(OwlTrigger.flyVector.x * factor * (float)delta) + Math.abs(OwlTrigger.flyVector.y * factor * (float)delta);
            if (!this.soundUsed) {
                this.getSound().loop();
                this.soundUsed = true;
            }
            if (currentOwlDistance >= maxOwlDistance) {
                this.getSound().stop();
                this.getDialog().start();
                owlLanded = true;
            }
        } else {
            float factor = 3.0f * (1.0f - 0.98f * (currentOwlDistance / maxOwlDistance));
            OwlTrigger.owlPos.x -= OwlTrigger.flyVector.x * factor * (float)delta;
            OwlTrigger.owlPos.y -= OwlTrigger.flyVector.y * factor * (float)delta;
            currentOwlDistance -= Math.abs(OwlTrigger.flyVector.x * factor * (float)delta) + Math.abs(OwlTrigger.flyVector.y * factor * (float)delta);
            if (!this.soundUsed) {
                this.getSound().loop();
                this.soundUsed = true;
            }
            if (currentOwlDistance <= 0.0f) {
                this.finished = true;
                this.getSound().stop();
            }
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (this.currentState == Trigger.State.Active) {
            GamePlay g = (GamePlay)game.getState(1);
            if (this.isAutomatic() && this.activated) {
                g.removeEntity(this);
                return;
            }
            this.activated = true;
            g.startOwl(this);
            this.currentState = Trigger.State.Inactive;
            if (this.isAutomatic()) {
                g.removeEntity(this);
            }
        }
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        if (game != null) {
            GamePlay g = (GamePlay)game.getState(1);
            if (this.dialogID != -1 && g.getMapData() != null) {
                this.dialog = g.getMapData().getDialogs().get(this.dialogID);
                if (this.dialog != null) {
                    this.dialog.setType(Dialog.SpeakerType.Owl);
                    this.dialog.init();
                }
            }
        }
        if (owl == null) {
            owl = new Image("data/character/owl.png");
        }
        if (owlFlying == null) {
            SpriteSheet fly = new SpriteSheet(new Image("data/character/owl_fly.png"), 234, 138);
            owlFlying = new Animation(fly, 50);
        }
        this.soundEffect = new Sound("data/sound/character/flap.ogg");
    }

    @Override
    public boolean activate(Hero h) {
        this.currentState = Trigger.State.Active;
        h.stopMoving(Direction.Right);
        h.stopMoving(Direction.Down);
        h.stopMoving(Direction.Left);
        h.stopMoving(Direction.Up);
        return true;
    }
}

