/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects.trigger;

import game.core.Constants;
import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.objects.Trigger;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.state.StateBasedGame;

public class DoorTrigger
extends Trigger {
    private static final int OPEN_DURATION = 100;
    private State currentState = State.Closed;
    private Animation openAnimation;
    private Type doorType;

    public DoorTrigger(Point2D.Float position, Type t) {
        super(position, false);
        this.doorType = t;
    }

    public Type getDoorType() {
        return this.doorType;
    }

    public void setDoorType(Type doorType) {
        this.doorType = doorType;
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        if (this.currentState == State.Closed) {
            return this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape());
        }
        return false;
    }

    @Override
    public Shape getNormalCollisionShape() {
        if (this.currentState == State.Open) {
            return Constants.EMPTY_COLLISION;
        }
        return super.getNormalCollisionShape();
    }

    @Override
    public Shape getCollisionShape() {
        if (this.currentState == State.Open) {
            return Constants.EMPTY_COLLISION;
        }
        return this.collision;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        Image[] anim = new Image[4];
        switch (this.doorType) {
            case Wood: {
                Image tmp = new Image("data/object/Wood_Door.png");
                this.objectImage = tmp.getSubImage(0, 0, tmp.getWidth(), 192);
                int i = 1;
                while (i < 5) {
                    anim[i - 1] = tmp.getSubImage(0, i * 192, tmp.getWidth(), 192);
                    ++i;
                }
                this.collision = new Rectangle(0.0f, 128.0f, tmp.getWidth(), 64.0f);
                break;
            }
            case Castle: {
                Image tmp = new Image("data/object/Stone_Door.png");
                this.objectImage = tmp.getSubImage(0, 0, tmp.getWidth(), 320);
                int i = 1;
                while (i < 5) {
                    anim[i - 1] = tmp.getSubImage(0, i * 320, tmp.getWidth(), 320);
                    ++i;
                }
                this.collision = new Rectangle(0.0f, 256.0f, tmp.getWidth(), 64.0f);
            }
        }
        this.openAnimation = new Animation(anim, 100);
        this.openAnimation.setLooping(false);
    }

    @Override
    public void draw(float x, float y) {
        x = this.position.x - x - this.collision.getCenterX();
        y = this.position.y - y - this.collision.getCenterY();
        switch (this.currentState) {
            case Open: {
                this.openAnimation.draw(x, y);
                break;
            }
            case Closed: {
                this.objectImage.draw(x, y);
            }
        }
    }

    @Override
    public boolean activate(Hero h) {
        if (h.getInventory().removeKey()) {
            this.currentState = State.Open;
            return true;
        }
        return false;
    }

    private static enum State {
        Closed,
        Open;

    }

    public static enum Type {
        Wood,
        Castle;

    }
}

