/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects.trigger;

import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.dialog.Dialog;
import game.core.mechanics.objects.Trigger;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

public class DialogTrigger
extends Trigger {
    Dialog dialog;
    int dialogID;

    public DialogTrigger(Point2D.Float position, boolean automatic, int dialogID) {
        super(position, automatic);
        this.setDialogID(dialogID);
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        return this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape());
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.loadDialog(container, game);
    }

    private void loadDialog(GameContainer container, StateBasedGame game) {
        if (game == null) {
            return;
        }
        GamePlay g = (GamePlay)game.getState(1);
        if (this.dialogID != -1 && g.getMapData() != null) {
            this.dialog = g.getMapData().getDialogs().get(this.dialogID);
            if (this.dialog != null) {
                this.dialog.init();
            }
        }
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        if (this.dialogID != -1) {
            Dialog.usedDialogs.remove((Object)this.dialogID);
        }
        if (dialog != null) {
            this.dialogID = dialog.getId();
            Dialog.usedDialogs.add(this.dialogID);
        } else {
            this.dialogID = -1;
        }
    }

    public int getDialogID() {
        return this.dialogID;
    }

    public void setDialogID(int dialogID) {
        if (this.dialogID != -1) {
            Dialog.usedDialogs.remove((Object)this.dialogID);
        }
        this.dialogID = dialogID;
        if (this.dialogID != -1) {
            Dialog.usedDialogs.add(this.dialogID);
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        super.update(container, game, delta);
        if (this.currentState == Trigger.State.Active) {
            this.currentState = Trigger.State.Inactive;
            if (game.getCurrentState() instanceof GamePlay) {
                GamePlay g = (GamePlay)game.getState(1);
                g.startDialog(this.dialog);
                if (this.isAutomatic()) {
                    g.removeEntity(this);
                }
            }
        }
    }

    @Override
    public boolean activate(Hero h) {
        this.currentState = Trigger.State.Active;
        return true;
    }

    public Dialog getDialog() {
        return this.dialog;
    }
}

