/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects;

import game.core.Constants;
import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.objects.GameObject;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.StateBasedGame;

public abstract class Usable
extends GameObject {
    protected Animation animationUsable;
    protected State currentState = State.Normal;

    public Image getObjectImage() {
        return this.objectImage;
    }

    public Usable(Point2D.Float position) {
        super(position);
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        if (this.animationUsable != null) {
            this.animationUsable.setLooping(false);
        }
        if (this.objectImage != null) {
            this.collision = new Rectangle(0.0f, 0.0f, this.objectImage.getWidth(), this.objectImage.getHeight());
        }
    }

    @Override
    public Vector2f getLastMovement() {
        return new Vector2f();
    }

    public abstract void useObject(Hero var1) throws SlickException;

    @Override
    public Shape getNormalCollisionShape() {
        if (this.currentState == State.Used) {
            return Constants.EMPTY_COLLISION;
        }
        return this.collision.transform(Transform.createTranslateTransform(this.position.x - this.getCollisionShape().getCenterX(), this.position.y - this.getCollisionShape().getCenterY()));
    }

    @Override
    public Shape getCollisionShape() {
        return this.collision;
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        return this.currentState != State.Used && this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape());
    }

    @Override
    public int getCollisionType() {
        return 7;
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        GamePlay g;
        Point2D.Float heroPos = ((GamePlay)game.getState(1)).getHero().getPosition();
        if (Math.abs(this.position.x - heroPos.x) > 896.0f || Math.abs(this.position.y - heroPos.y) > 896.0f) {
            ((GamePlay)game.getState(1)).removeEntity(this);
        }
        if (this.animationUsable != null && this.animationUsable.isStopped()) {
            g = (GamePlay)game.getState(1);
            g.removeEntity(this);
        }
        if (this.currentState == State.Used) {
            g = (GamePlay)game.getState(1);
            g.removeEntity(this);
        }
    }

    @Override
    public void draw(float x, float y) {
        x = this.position.x - x - this.collision.getCenterX();
        y = this.position.y - y - this.collision.getCenterY();
        switch (this.currentState) {
            case Normal: {
                this.objectImage.draw(x, y);
                break;
            }
            case Used: {
                if (this.animationUsable == null) break;
                this.animationUsable.draw(x, y);
            }
        }
    }

    protected static enum State {
        Normal,
        Used;

    }
}

