/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects;

import game.core.mechanics.character.Hero;
import game.core.mechanics.objects.GameObject;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.StateBasedGame;

public abstract class Trigger
extends GameObject {
    boolean automatic;
    protected State currentState = State.Inactive;

    public Trigger(Point2D.Float position, boolean automatic) {
        super(position);
        this.automatic = automatic;
        this.collision = new Rectangle(0.0f, 0.0f, 64.0f, 64.0f);
    }

    public void setCollisionWidth(float width) {
        this.collision = new Rectangle(this.collision.getX(), this.collision.getY(), width, this.collision.getHeight());
    }

    public void setCollisionHeight(float height) {
        this.collision = new Rectangle(this.collision.getX(), this.collision.getY(), this.collision.getWidth(), height);
    }

    @Override
    public Shape getNormalCollisionShape() {
        return this.getCollisionShape().transform(Transform.createTranslateTransform(this.position.x - this.getCollisionShape().getCenterX(), this.position.y - this.getCollisionShape().getCenterY()));
    }

    @Override
    public Shape getCollisionShape() {
        return this.collision;
    }

    @Override
    public int getCollisionType() {
        return 8;
    }

    public abstract boolean activate(Hero var1);

    public boolean isAutomatic() {
        return this.automatic;
    }

    @Override
    public Vector2f getLastMovement() {
        return new Vector2f();
    }

    @Override
    public void draw(float x, float y) {
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        Point2D.Float heroPos = ((GamePlay)game.getState(1)).getHero().getPosition();
        if (Math.abs(this.position.x - heroPos.x) > 896.0f || Math.abs(this.position.y - heroPos.y) > 896.0f) {
            ((GamePlay)game.getState(1)).removeEntity(this);
        }
    }

    protected static enum State {
        Active,
        Inactive;

    }

    public static enum TriggerType {
        Door,
        Owl,
        Checkpoint,
        Dialog;

    }
}

