/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects;

import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.objects.GameObject;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.state.StateBasedGame;

public class AnimationObject
extends GameObject {
    private AnimationObjectType type;
    private Animation object;

    public AnimationObjectType getObjectType() {
        return this.type;
    }

    public AnimationObject(Point2D.Float position, AnimationObjectType type) {
        super(position);
        this.type = type;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        switch (this.type) {
            case Torch: {
                Image tmp = new Image("data/object/torch.png");
                this.object = new Animation(new SpriteSheet(tmp, 60, tmp.getHeight()), 200);
                this.collision = new Rectangle(15.0f, 77.0f, 30.0f, 30.0f);
            }
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
    }

    @Override
    public void draw(float x, float y) {
        this.object.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
    }

    @Override
    public Shape getNormalCollisionShape() {
        return this.collision.transform(Transform.createTranslateTransform(this.position.x - this.collision.getCenterX(), this.position.y - this.collision.getCenterY()));
    }

    @Override
    public Shape getCollisionShape() {
        return this.collision;
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        return this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape()) || this.getNormalCollisionShape().contains(collidable.getNormalCollisionShape());
    }

    public static enum AnimationObjectType {
        Torch;

    }
}

