/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.dialog;

import java.awt.Color;
import java.util.LinkedList;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;

public class Dialog {
    private static Sound textSound;
    private int id = -1;
    private static int currentID;
    private static Image dialogBackground;
    private LinkedList<String> text = new LinkedList();
    private LinkedList<String> currentDisplay = new LinkedList();
    public static LinkedList<Integer> usedDialogs;
    private int currentText = 0;
    private SpeakerType type;
    private Sound sfx;
    private Image speaker;
    private int lastKeyStroke = 0;
    private static final int KEY_STROKE_THRESHHOLD = 800;
    private static UnicodeFont font;
    Input currentInput;

    static {
        currentID = 0;
        usedDialogs = new LinkedList();
        font = null;
    }

    public boolean isUsed() {
        return usedDialogs.contains(this.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Dialog) {
            Dialog other = (Dialog)obj;
            return this.id == other.id;
        }
        return false;
    }

    public Dialog(int id) {
        if (id >= 0) {
            this.id = id;
            if (id > currentID) {
                currentID = id + 1;
            }
        } else {
            this.id = currentID++;
        }
    }

    public void setType(SpeakerType type) {
        this.type = type;
    }

    public SpeakerType getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public LinkedList<String> getText() {
        return this.text;
    }

    public void continueDialog() {
        ++this.currentText;
        textSound.play();
        this.currentDisplay.clear();
        this.currentDisplay = this.getCurrentText();
    }

    public void addDialogText(String text) {
        this.text.add(text);
    }

    public void deleteDialogText(String text) {
        this.text.remove(text);
    }

    private LinkedList<String> getCurrentText() {
        LinkedList<String> result = new LinkedList<String>();
        if (this.isFinished()) {
            return result;
        }
        String[] words = this.text.get(this.currentText).split(" ");
        String current = "";
        if (words.length >= 1) {
            current = words[0];
        }
        int i = 1;
        while (i < words.length) {
            if (words[i].contains("\n")) {
                String[] newS = words[i].split("\n");
                if (font.getWidth(String.valueOf(current) + " " + newS[0]) < 780) {
                    result.add(String.valueOf(current) + " " + newS[0]);
                } else {
                    result.add(current);
                    result.add(newS[0]);
                }
                int j = 1;
                while (j < newS.length) {
                    current = newS[j];
                    if (j != newS.length - 1) {
                        result.add(current);
                    }
                    ++j;
                }
            } else if (font.getWidth(String.valueOf(current) + " " + words[i]) > 780) {
                result.add(current);
                current = words[i];
            } else {
                current = String.valueOf(current) + " " + words[i];
            }
            ++i;
        }
        if (current != "") {
            result.add(current);
        }
        i = 0;
        while (i < result.size()) {
            result.get(i).contains("\n");
            ++i;
        }
        return result;
    }

    public boolean isFinished() {
        return this.currentText >= this.text.size();
    }

    public void start() {
        if (this.sfx != null) {
            this.sfx.play();
        }
        this.currentText = 0;
        this.currentDisplay.clear();
        this.currentDisplay = this.getCurrentText();
    }

    private void loadFont() throws SlickException {
        font = new UnicodeFont("data/font/kratos.ttf", 24, false, false);
        font.addAsciiGlyphs();
        font.addGlyphs(400, 600);
        font.getEffects().add(new ColorEffect(Color.WHITE));
        font.loadGlyphs();
    }

    public void init() {
        this.currentText = 0;
        try {
            if (textSound == null) {
                textSound = new Sound("data/sound/sfx/dialog.ogg");
            }
            this.loadFont();
            if (dialogBackground == null) {
                dialogBackground = new Image("data/dialog.png");
            }
            switch (this.type) {
                case BigGuard: {
                    this.speaker = new Image("data/character/bossSpeaker.png");
                    break;
                }
                case Beggar: {
                    this.speaker = new Image("data/character/crippleSpeaker.png");
                    this.sfx = new Sound("data/sound/character/cripple.ogg");
                    break;
                }
                case Child: {
                    this.speaker = new Image("data/character/childSpeaker.png");
                    this.sfx = new Sound("data/sound/character/child.ogg");
                    break;
                }
                case Man: {
                    this.speaker = new Image("data/character/manSpeaker.png");
                    this.sfx = new Sound("data/sound/character/man.ogg");
                    break;
                }
                case Owl: {
                    this.speaker = new Image("data/character/owl.png");
                    break;
                }
                case Sign: {
                    this.speaker = new Image("data/character/owl.png");
                    break;
                }
                case Woman: {
                    this.speaker = new Image("data/character/womanSpeaker.png");
                    this.sfx = new Sound("data/sound/character/woman.ogg");
                }
            }
        }
        catch (SlickException e) {
            System.err.println("Dialog: Text Sound not found!");
        }
    }

    public void draw(Graphics g) {
        dialogBackground.draw(121.0f, 449.0f);
        g.setColor(org.newdawn.slick.Color.white);
        g.setFont(font);
        if (this.currentDisplay == null) {
            return;
        }
        if (this.speaker != null) {
            this.speaker.draw(235 - this.speaker.getWidth() / 2, 669 - this.speaker.getHeight());
        }
        int i = 0;
        while (i < this.currentDisplay.size()) {
            g.drawString(this.currentDisplay.get(i), 358.0f, 462 + font.getHeight("ABCDEFGHIJKLMNOPQRSTUVWXYZ!?,;:*") * i);
            ++i;
        }
    }

    public void update(Input input, int delta) throws SlickException {
        this.lastKeyStroke += delta;
        if (this.lastKeyStroke >= 800 && input.isKeyDown(57)) {
            this.continueDialog();
            this.lastKeyStroke = 0;
        }
    }

    public String toString() {
        if (this.text != null && this.text.size() > 0) {
            if (this.text.getFirst().length() < 20) {
                return String.valueOf(this.id) + ": \"" + this.text.getFirst().substring(0, this.text.getFirst().length()) + "\"";
            }
            return String.valueOf(this.id) + ": \"" + this.text.getFirst().substring(0, 20) + "\"";
        }
        return String.valueOf(this.id) + ": \"\"";
    }

    public static enum SpeakerType {
        Man,
        Woman,
        Beggar,
        Child,
        Sign,
        Owl,
        BigGuard;

    }
}

