/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision.handlers;

import game.core.mechanics.character.Enemy;
import game.core.mechanics.collision.CollisionManager;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.collision.ICollisionHandler;
import game.core.mechanics.collision.WeaponCollisionData;

public class HandlerWeaponEnemy
implements ICollisionHandler {
    @Override
    public int getColliderType() {
        return 4;
    }

    @Override
    public int[] getCollidesWithTypes() {
        return new int[]{2};
    }

    @Override
    public void performCollision(ICollidableObject collidable1, ICollidableObject collidable2, CollisionManager manager) {
        WeaponCollisionData w;
        Enemy e;
        if (!collidable1.isCollidingWith(collidable2)) {
            return;
        }
        if (collidable1 instanceof Enemy) {
            e = (Enemy)collidable1;
            w = (WeaponCollisionData)collidable2;
        } else {
            e = (Enemy)collidable2;
            w = (WeaponCollisionData)collidable1;
        }
        if (e == w.getAttacker() || w.getAttacker() instanceof Enemy || !e.isHitable()) {
            return;
        }
        e.decreaseHP(w.getWeaponDamage());
        float distX = e.getPosition().x - w.getAttackerPosition().x;
        float distY = e.getPosition().y - w.getAttackerPosition().y;
        if (Math.abs(distX) < 10.0f) {
            e.pushTo(0.0f, Math.copySign(150.0f, distY));
        } else if (Math.abs(distY) < 10.0f) {
            e.pushTo(Math.copySign(150.0f, distX), 0.0f);
        } else {
            e.pushTo(Math.copySign(115.5f, distX), Math.copySign(115.5f, distY));
        }
    }
}

