/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision.handlers;

import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.CollisionManager;
import game.core.mechanics.collision.HeroTriggerCollision;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.collision.ICollisionHandler;
import game.core.mechanics.collision.handlers.CollisionHelper;
import game.core.mechanics.objects.Usable;
import game.core.mechanics.objects.usable.Chest;
import org.newdawn.slick.SlickException;

public class HandlerUsableHero
implements ICollisionHandler {
    @Override
    public int getColliderType() {
        return 7;
    }

    @Override
    public int[] getCollidesWithTypes() {
        return new int[]{1, 9};
    }

    @Override
    public void performCollision(ICollidableObject collidable1, ICollidableObject collidable2, CollisionManager manager) {
        Usable u;
        if (!collidable1.isCollidingWith(collidable2)) {
            return;
        }
        Hero hero = null;
        HeroTriggerCollision heroT = null;
        if (collidable1 instanceof Usable) {
            u = (Usable)collidable1;
            if (collidable2 instanceof Hero) {
                hero = (Hero)collidable2;
            } else {
                heroT = (HeroTriggerCollision)collidable2;
            }
        } else {
            u = (Usable)collidable2;
            if (collidable1 instanceof Hero) {
                hero = (Hero)collidable1;
            } else {
                heroT = (HeroTriggerCollision)collidable1;
            }
        }
        if (!(u instanceof Chest)) {
            if (hero != null) {
                try {
                    u.useObject(hero);
                }
                catch (SlickException e) {
                    System.err.println("Error while using Usable!");
                }
            }
        } else if (hero != null) {
            CollisionHelper.simpleObjectCollision(u, hero, manager);
        } else {
            heroT.getHero().setCurrentTriggerTarget(u);
        }
    }
}

