/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision.handlers;

import game.core.mechanics.character.Enemy;
import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.CollisionManager;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.collision.ICollisionHandler;
import game.core.mechanics.collision.handlers.CollisionHelper;

public class HandlerHeroEnemy
implements ICollisionHandler {
    @Override
    public int getColliderType() {
        return 1;
    }

    @Override
    public int[] getCollidesWithTypes() {
        return new int[]{2};
    }

    @Override
    public void performCollision(ICollidableObject collidable1, ICollidableObject collidable2, CollisionManager manager) {
        Enemy e;
        Hero h;
        if (!collidable1.isCollidingWith(collidable2)) {
            return;
        }
        if (collidable1.getClass() == Hero.class) {
            h = (Hero)collidable1;
            e = (Enemy)collidable2;
        } else {
            h = (Hero)collidable2;
            e = (Enemy)collidable1;
        }
        float distX = h.getPosition().x - e.getPosition().x;
        float distY = h.getPosition().y - e.getPosition().y;
        CollisionHelper.simpleObjectCollision(h, e, manager);
        if (!h.isHitable()) {
            return;
        }
        h.decreaseHP(e.getBodyDamage());
        if (Math.abs(distX) < 10.0f) {
            h.pushTo(0.0f, Math.copySign(150.0f, distY));
        } else if (Math.abs(distY) < 10.0f) {
            h.pushTo(Math.copySign(150.0f, distX), 0.0f);
        } else {
            h.pushTo(Math.copySign(115.5f, distX), Math.copySign(115.5f, distY));
        }
    }
}

