/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision.handlers;

import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.collision.CollisionManager;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.collision.ICollisionHandler;
import game.core.mechanics.collision.handlers.CollisionHelper;
import game.core.mechanics.objects.Destructible;

public class HandlerDestructibleGameCharacter
implements ICollisionHandler {
    @Override
    public int getColliderType() {
        return 5;
    }

    @Override
    public int[] getCollidesWithTypes() {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        return nArray;
    }

    @Override
    public void performCollision(ICollidableObject collidable1, ICollidableObject collidable2, CollisionManager manager) {
        Destructible d;
        GameCharacter h;
        if (!collidable1.isCollidingWith(collidable2)) {
            return;
        }
        if (collidable1 instanceof GameCharacter) {
            h = (GameCharacter)collidable1;
            d = (Destructible)collidable2;
        } else {
            h = (GameCharacter)collidable2;
            d = (Destructible)collidable1;
        }
        CollisionHelper.simpleObjectCollision(d, h, manager);
    }
}

