/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision;

import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.collision.ICollidableObject;
import java.awt.geom.Point2D;
import org.newdawn.slick.geom.Shape;

public class WeaponCollisionData
implements ICollidableObject {
    public int weaponDamage;
    public GameCharacter attacker;
    private Shape normalCollisionShape;

    public WeaponCollisionData(int weaponDamage, GameCharacter attacker, Shape normalCollisionShape) {
        this.weaponDamage = weaponDamage;
        this.attacker = attacker;
        this.normalCollisionShape = normalCollisionShape;
    }

    public int getWeaponDamage() {
        return this.weaponDamage;
    }

    public Point2D.Float getAttackerPosition() {
        return this.attacker.getPosition();
    }

    public void setNormalCollisionShape(Shape collision) {
        this.normalCollisionShape = collision;
    }

    public GameCharacter getAttacker() {
        return this.attacker;
    }

    @Override
    public Point2D.Float getPosition() {
        return null;
    }

    @Override
    public Shape getNormalCollisionShape() {
        return this.normalCollisionShape;
    }

    @Override
    public Shape getCollisionShape() {
        return null;
    }

    @Override
    public int getCollisionType() {
        return 4;
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        return this.normalCollisionShape.intersects(collidable.getNormalCollisionShape());
    }
}

