/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision;

import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.ICollidableObject;
import java.awt.geom.Point2D;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;

public class HeroTriggerCollision
implements ICollidableObject {
    Hero h;
    Rectangle col;

    public HeroTriggerCollision(Hero h) {
        this.h = h;
        this.col = new Rectangle(0.0f, 0.0f, 64.0f, 64.0f);
    }

    @Override
    public Point2D.Float getPosition() {
        Point2D.Float result = (Point2D.Float)this.h.getPosition().clone();
        switch (this.h.getDirection()) {
            case Down: {
                result.y += this.h.getCollisionShape().getHeight() / 2.0f;
                break;
            }
            case Left: {
                result.x -= this.h.getCollisionShape().getWidth() / 2.0f;
                break;
            }
            case Right: {
                result.x += this.h.getCollisionShape().getWidth() / 2.0f;
                break;
            }
            case Up: {
                result.y -= this.h.getCollisionShape().getHeight() / 2.0f;
            }
        }
        return result;
    }

    @Override
    public Shape getNormalCollisionShape() {
        Point2D.Float position = this.getPosition();
        return this.col.transform(Transform.createTranslateTransform(position.x - this.getCollisionShape().getCenterX(), position.y - this.getCollisionShape().getCenterY()));
    }

    @Override
    public Shape getCollisionShape() {
        return this.col;
    }

    @Override
    public int getCollisionType() {
        return 9;
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        return this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape());
    }

    public Hero getHero() {
        return this.h;
    }
}

