/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision;

import game.core.mechanics.IGameEntity;
import game.core.mechanics.character.Enemy;
import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.collision.ICollisionHandler;
import game.core.mechanics.collision.WeaponCollisionData;
import game.core.mechanics.pathfinding.Path;
import game.core.mechanics.pathfinding.PathThread;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.tiled.TiledMap;
import org.newdawn.slick.util.pathfinding.AStarPathFinder;
import org.newdawn.slick.util.pathfinding.Mover;
import org.newdawn.slick.util.pathfinding.PathFindingContext;
import org.newdawn.slick.util.pathfinding.TileBasedMap;

public class CollisionManager
implements TileBasedMap {
    private Map<Integer, List<ICollidableObject>> collidables = new HashMap<Integer, List<ICollidableObject>>();
    private Map<Integer, List<Integer>> collisionsTypes = new HashMap<Integer, List<Integer>>();
    private Map<String, ICollisionHandler> collisionHandlers = new HashMap<String, ICollisionHandler>();
    private boolean[][] mapCollision;
    AStarPathFinder pathFinder;

    public boolean[][] getMapCollision() {
        return this.mapCollision;
    }

    public CollisionManager(TiledMap map, int collisionLayer) {
        this.calculateCollision(map, collisionLayer);
        this.pathFinder = new AStarPathFinder(this, 10, true);
    }

    private void calculateCollision(TiledMap map, int collisionLayer) {
        this.mapCollision = new boolean[map.getWidth()][map.getHeight()];
        int x = 0;
        while (x < this.mapCollision.length) {
            int y = 0;
            while (y < this.mapCollision[0].length) {
                this.mapCollision[x][y] = map.getTileId(x, y, collisionLayer) > 0;
                ++y;
            }
            ++x;
        }
    }

    public void getPath(Point2D start, Point2D end, Mover m, Path old) {
        if (this.pathFinder == null || start == null || end == null) {
            return;
        }
        new PathThread(start, end, m, old, this.pathFinder).run();
    }

    public void addCollidable(ICollidableObject collidable) {
        WeaponCollisionData weapon;
        List<ICollidableObject> collidableList = this.collidables.get(collidable.getCollisionType());
        if (collidable instanceof Enemy && (weapon = ((Enemy)collidable).getWeaponCollision()) != null) {
            this.addCollidable(weapon);
        }
        if (collidable instanceof Hero) {
            weapon = ((Hero)collidable).getWeaponCollision();
            if (weapon != null) {
                this.addCollidable(weapon);
            }
            this.addCollidable(((Hero)collidable).getTriggerCollision());
        }
        if (collidableList == null) {
            collidableList = new ArrayList<ICollidableObject>();
            this.collidables.put(collidable.getCollisionType(), collidableList);
        }
        collidableList.add(collidable);
    }

    public void removeCollidable(ICollidableObject collidable) {
        List<ICollidableObject> collidableList = this.collidables.get(collidable.getCollisionType());
        if (collidableList != null) {
            WeaponCollisionData weapon;
            collidableList.remove(collidable);
            if (collidable instanceof Enemy && (weapon = ((Enemy)collidable).getWeaponCollision()) != null) {
                this.removeCollidable(weapon);
            }
            if (collidable instanceof Hero && (weapon = ((Hero)collidable).getWeaponCollision()) != null) {
                this.removeCollidable(weapon);
            }
        }
    }

    public void addHandler(ICollisionHandler handler) {
        int[] nArray = handler.getCollidesWithTypes();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int collideWith = nArray[n2];
            String key = CollisionManager.getKey(handler.getColliderType(), collideWith);
            this.collisionHandlers.put(key, handler);
            this.addTypesToCollision(handler.getColliderType(), collideWith);
            this.addTypesToCollision(collideWith, handler.getColliderType());
            ++n2;
        }
    }

    private void addTypesToCollision(int type1, int type2) {
        List<Integer> typeCollisions = this.collisionsTypes.get(type1);
        if (typeCollisions == null) {
            typeCollisions = new ArrayList<Integer>();
            this.collisionsTypes.put(type1, typeCollisions);
        }
        typeCollisions.add(type2);
    }

    private boolean isEntityCollidingWithMap(IGameEntity entity, float adjX, float adjY) {
        int centerY;
        Shape curCol = entity.getNormalCollisionShape();
        Vector2f lastMov = entity.getLastMovement();
        if (lastMov.equals(new Vector2f())) {
            return false;
        }
        if (curCol.getMinX() < 0.0f || curCol.getMaxX() > (float)(this.mapCollision.length * 64)) {
            return true;
        }
        if (curCol.getMinY() < 0.0f || curCol.getMaxY() > (float)(this.mapCollision[0].length * 64)) {
            return true;
        }
        int minX = (int)(curCol.getMinX() + adjX) / 64;
        int maxX = (int)(curCol.getMaxX() + adjX) / 64;
        int minY = (int)(curCol.getMinY() + adjY) / 64;
        int maxY = (int)(curCol.getMaxY() + adjY) / 64;
        int centerX = (int)(curCol.getCenterX() + adjX) / 64;
        if (this.mapCollision[centerX][centerY = (int)(curCol.getCenterY() + adjY) / 64]) {
            return true;
        }
        if (this.mapCollision[minX][minY]) {
            return true;
        }
        if (this.mapCollision[maxX][minY]) {
            return true;
        }
        if (this.mapCollision[minX][maxY]) {
            return true;
        }
        return this.mapCollision[maxX][maxY];
    }

    private void processMapCollision(IGameEntity entity) {
        Vector2f lastMov = entity.getLastMovement();
        if (lastMov.equals(new Vector2f()) || !this.isEntityCollidingWithMap(entity, 0.0f, 0.0f)) {
            return;
        }
        Point2D.Float newPos = (Point2D.Float)entity.getPosition().clone();
        Point2D.Float oldPos = (Point2D.Float)newPos.clone();
        boolean colX = false;
        boolean colY = false;
        if (lastMov.getX() != 0.0f) {
            if (!this.isEntityColiding(entity, -lastMov.x, 0.0f, false)) {
                colX = true;
            }
            newPos.x = oldPos.x;
        }
        if (lastMov.getY() != 0.0f) {
            if (!this.isEntityColiding(entity, 0.0f, -lastMov.y, false)) {
                colY = true;
            }
            newPos.y = oldPos.y;
        }
        if (colX) {
            newPos.x -= lastMov.x;
        }
        if (colY) {
            newPos.y -= lastMov.y;
        }
        if (!colX && !colY) {
            newPos.x -= lastMov.x;
            newPos.y -= lastMov.y;
        }
        entity.setPosition(newPos);
    }

    public static String getKey(int type1, int type2) {
        return type1 < type2 ? String.valueOf(type1) + "-" + type2 : String.valueOf(type2) + "-" + type1;
    }

    public boolean isEntityColiding(IGameEntity e, float adjX, float adjY, boolean path) {
        List<Integer> collidesWithTypes = this.collisionsTypes.get(e.getCollisionType());
        for (Integer collidingType : collidesWithTypes) {
            List<ICollidableObject> collidableForCollidingType = this.collidables.get(collidingType);
            if (collidableForCollidingType == null) continue;
            for (ICollidableObject collidesWith : collidableForCollidingType) {
                if (e == collidesWith || path && collidesWith instanceof Hero || !e.isCollidingWith(collidesWith)) continue;
                return true;
            }
        }
        return this.isEntityCollidingWithMap(e, adjX, adjY);
    }

    public void processCollisions() {
        HashSet<String> allCollisionKeys = new HashSet<String>();
        ArrayList<CollisionData> collisions = new ArrayList<CollisionData>();
        Set<Integer> types = this.collisionsTypes.keySet();
        for (Integer n : types) {
            List<Integer> collidesWithTypes = this.collisionsTypes.get(n);
            for (Integer collidingType : collidesWithTypes) {
                if (allCollisionKeys.contains(CollisionManager.getKey(n, collidingType))) continue;
                List<ICollidableObject> collidableForType = this.collidables.get(n);
                List<ICollidableObject> collidableForCollidingType = this.collidables.get(collidingType);
                if (collidableForCollidingType == null || collidableForType == null) continue;
                for (ICollidableObject collidable : collidableForType) {
                    for (ICollidableObject collidesWith : collidableForCollidingType) {
                        if (collidable == collidesWith || !collidable.isCollidingWith(collidesWith)) continue;
                        CollisionData cd = new CollisionData();
                        cd.handler = this.collisionHandlers.get(CollisionManager.getKey(n, collidingType));
                        cd.object1 = collidable;
                        cd.object2 = collidesWith;
                        collisions.add(cd);
                    }
                }
                allCollisionKeys.add(CollisionManager.getKey(n, collidingType));
            }
        }
        for (List list : this.collidables.values()) {
            for (ICollidableObject collider : list) {
                if (!(collider instanceof IGameEntity)) continue;
                this.processMapCollision((IGameEntity)collider);
            }
        }
        for (CollisionData collisionData : collisions) {
            collisionData.handler.performCollision(collisionData.object1, collisionData.object2, this);
        }
    }

    @Override
    public int getWidthInTiles() {
        return this.mapCollision.length;
    }

    @Override
    public int getHeightInTiles() {
        return this.mapCollision[0].length;
    }

    @Override
    public void pathFinderVisited(int x, int y) {
    }

    @Override
    public boolean blocked(PathFindingContext context, int tx, int ty) {
        boolean result;
        IGameEntity m = (IGameEntity)((Object)context.getMover());
        if (m == null) {
            result = this.mapCollision[tx][ty];
        } else {
            Point2D.Float oldP = (Point2D.Float)m.getPosition().clone();
            m.setPosition(new Point2D.Float(tx * 64 + 32, ty * 64 + 32));
            result = this.isEntityColiding(m, 0.0f, 0.0f, true);
            m.setPosition(oldP);
        }
        return result;
    }

    @Override
    public float getCost(PathFindingContext context, int tx, int ty) {
        return 1.0f;
    }

    class CollisionData {
        public ICollisionHandler handler;
        public ICollidableObject object1;
        public ICollidableObject object2;

        CollisionData() {
        }
    }
}

