/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.character;

import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public class Inventory {
    private static Image[] heartImage = new Image[3];
    private static Image[] potionImage = new Image[2];
    private static Image[] keyImage = new Image[2];
    int keys;
    int potion;
    int maxPotion;

    public Inventory(int keys, int potion, int maxPotion) {
        this.keys = keys;
        this.potion = potion;
        this.maxPotion = maxPotion;
        if (keys < 0) {
            this.keys = 0;
        }
        if (potion < 0) {
            this.potion = 0;
        }
        try {
            this.initPictures();
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }

    private void initPictures() throws SlickException {
        if (heartImage[0] == null) {
            Inventory.heartImage[0] = new Image("data/ui/heart_full.png");
            Inventory.heartImage[1] = new Image("data/ui/heart_half.png");
            Inventory.heartImage[2] = new Image("data/ui/heart_empty.png");
        }
        if (potionImage[0] == null) {
            Inventory.potionImage[0] = new Image("data/ui/potion.png");
            Inventory.potionImage[1] = new Image("data/ui/potion_trans.png");
        }
        if (keyImage[0] == null) {
            Inventory.keyImage[0] = new Image("data/ui/key.png");
            Inventory.keyImage[1] = new Image("data/ui/key_trans.png");
        }
    }

    public int getKeys() {
        return this.keys;
    }

    public int getPotion() {
        return this.potion;
    }

    public boolean addPotion() {
        if (this.maxPotion == -1 || this.potion != this.maxPotion) {
            ++this.potion;
            return true;
        }
        return false;
    }

    public boolean removePotion() {
        if (this.potion == 0) {
            return false;
        }
        --this.potion;
        return true;
    }

    public int getMaxPotions() {
        return this.maxPotion;
    }

    public void increaseMaxPotions() {
        ++this.maxPotion;
    }

    public boolean addKey() {
        ++this.keys;
        return true;
    }

    public boolean removeKey() {
        if (this.keys > 0) {
            --this.keys;
            return true;
        }
        return false;
    }

    public void draw(int aktHP, int maxHP) {
        int i = 1;
        while (i <= maxHP) {
            if (aktHP >= i + 1) {
                heartImage[0].draw(103 + i / 2 * 33, 27.0f);
            } else if (aktHP >= i) {
                heartImage[1].draw(103 + i / 2 * 33, 27.0f);
            } else {
                heartImage[2].draw(103 + i / 2 * 33, 27.0f);
            }
            i += 2;
        }
        if (this.keys > 0) {
            keyImage[0].draw(162.0f, 63.0f);
        } else {
            keyImage[1].draw(162.0f, 63.0f);
        }
        if (this.potion > 0) {
            potionImage[0].draw(102.0f, 63.0f);
        } else {
            potionImage[1].draw(102.0f, 63.0f);
        }
    }
}

