/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.character;

import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.collision.WeaponCollisionData;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.StateBasedGame;

public abstract class Enemy
extends GameCharacter {
    short aktHP;
    short maxHP;
    Sound alertSound;
    Animation alertAnimation;
    Animation deathAnimation;
    Sound moan = null;
    int bodyDamage;
    private boolean playedOnce = false;
    protected int getNewPath = 0;
    protected int retryPathfinding = 5000;

    public Enemy() {
        this.charState = GameCharacter.CharacterState.Waiting;
        try {
            Image death = new Image("data/death.png");
            SpriteSheet deathSprite = new SpriteSheet(death, 104, death.getHeight());
            this.deathAnimation = new Animation(deathSprite, 50);
            this.deathAnimation.setLooping(false);
            Image alert = new Image("data/alert.png");
            SpriteSheet alertSprite = new SpriteSheet(alert, 50, 50);
            this.alertAnimation = new Animation(alertSprite, 150);
            this.alertAnimation.setLooping(false);
            this.sfx = new Sound("data/sound/sfx/dying.ogg");
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getCollisionType() {
        return 2;
    }

    public void decreaseHP(int value) {
        if (this.charState == GameCharacter.CharacterState.Hit) {
            return;
        }
        this.aktHP = (short)(this.aktHP - value);
        if (this.aktHP <= 0) {
            this.aktHP = 0;
            this.charState = GameCharacter.CharacterState.Dead;
            this.sfx.play();
        } else if (this.moan != null) {
            this.moan.play();
        }
    }

    public short getAktHP() {
        return this.aktHP;
    }

    public int getBodyDamage() {
        return this.bodyDamage;
    }

    @Override
    public void draw(float x, float y) {
        if (this.charState == GameCharacter.CharacterState.Dead) {
            this.deathAnimation.draw(this.position.x - x - (float)(this.deathAnimation.getWidth() / 2), this.position.y - y - (float)this.deathAnimation.getHeight());
        } else {
            super.draw(x, y);
            if (this.charState == GameCharacter.CharacterState.Alert) {
                this.alertAnimation.draw(this.position.x - x - (float)(this.alertAnimation.getWidth() / 2), this.position.y - y - this.collision.getCenterY() - (float)this.alertAnimation.getHeight());
            }
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        Point2D.Float heroPos = ((GamePlay)game.getState(1)).getHero().getPosition();
        switch (this.charState) {
            case Moving: {
                if (this.retryPathfinding > 0 && (heroPos.distance(this.position) < 128.0 || this.path.getLength() == 0)) {
                    this.path.clear();
                    this.path.appendStep((int)heroPos.x, (int)heroPos.y);
                    this.currentStep = 0;
                    this.getNewPath = 0;
                    this.retryPathfinding -= delta;
                } else {
                    if (this.getNewPath <= 0) {
                        ((GamePlay)game.getState(1)).getCollisionManager().getPath(this.position, heroPos, this, this.path);
                        this.getNewPath = 500;
                        this.currentStep = 1;
                        this.retryPathfinding = 5000;
                    }
                    this.getNewPath -= delta;
                }
                super.update(container, game, delta);
                break;
            }
            case Waiting: {
                if (this.position.x < heroPos.x - 576.0f || this.position.x > heroPos.x + 576.0f || this.position.y < heroPos.y - 296.0f || this.position.y > heroPos.y + 296.0f) {
                    this.charState = GameCharacter.CharacterState.Waiting;
                    break;
                }
                this.charState = GameCharacter.CharacterState.Alert;
                break;
            }
            case Alert: {
                if (!this.alertAnimation.isStopped()) break;
                this.charState = GameCharacter.CharacterState.Moving;
                break;
            }
            case Dead: {
                this.lastMovement = new Vector2f();
                if (!this.playedOnce) {
                    this.sfx.play();
                    this.playedOnce = true;
                }
                if (!this.deathAnimation.isStopped()) break;
                ((GamePlay)game.getState(1)).removeEntity(this);
                break;
            }
            case Standing: {
                this.charState = GameCharacter.CharacterState.Moving;
                break;
            }
            case Hit: {
                super.update(container, game, delta);
                break;
            }
            case Custom: {
                if (!this.blinking) break;
                super.update(container, game, delta);
            }
        }
    }

    public abstract WeaponCollisionData getWeaponCollision();
}

