/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.character;

import game.core.mechanics.Direction;
import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.dialog.Dialog;
import game.states.GamePlay;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.state.StateBasedGame;

public class Citizen
extends GameCharacter {
    Dialog dialog;
    int dialogID = -1;
    private static final int CITIZEN_HEIGHT = 121;
    private static final int CITIZEN_WIDTH = 72;
    private static final int CITIZEN_HEIGHT_CHILD = 80;
    private static final int CITIZEN_WIDTH_CHILD = 50;
    int citizenType;
    private static final int moveSpeed = 100;
    private boolean startDialog = false;
    float startPos;
    int waitTime = 4000;

    public Citizen(int citizenType, int dialogID) {
        this.citizenType = citizenType;
        this.setDialogID(dialogID);
    }

    public void setCitizenType(int citizenType) {
        this.citizenType = citizenType;
    }

    public int getCitizenType() {
        return this.citizenType;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.speed = 0.03f;
        this.charState = GameCharacter.CharacterState.Moving;
        this.collision = new Rectangle(0.0f, 85.0f, 72.0f, 36.0f);
        if (game != null) {
            GamePlay g = (GamePlay)game.getState(1);
            if (this.dialogID != -1 && g.getMapData() != null) {
                this.dialog = g.getMapData().getDialogs().get(this.dialogID);
                if (this.dialog != null) {
                    switch (this.citizenType) {
                        case 1: {
                            this.dialog.setType(Dialog.SpeakerType.Man);
                            break;
                        }
                        case 2: {
                            this.dialog.setType(Dialog.SpeakerType.Woman);
                            break;
                        }
                        case 3: {
                            this.dialog.setType(Dialog.SpeakerType.Child);
                            break;
                        }
                        case 4: {
                            this.dialog.setType(Dialog.SpeakerType.Beggar);
                        }
                    }
                    this.dialog.init();
                }
            }
        }
        if (this.citizenType == 1) {
            Image citizenMan = new Image("data/character/citizen_man.png");
            Image[] animMan = new Image[4];
            int i = 0;
            while (i < 4) {
                animMan[i] = citizenMan.getSubImage(0, i * 121, 72, 121);
                ++i;
            }
            SpriteSheet tempMan = new SpriteSheet(animMan[0], 72, 121);
            this.up = new Animation(tempMan, 100);
            tempMan = new SpriteSheet(animMan[1], 72, 121);
            this.down = new Animation(tempMan, 100);
            tempMan = new SpriteSheet(animMan[2], 72, 121);
            this.left = new Animation(tempMan, 100);
            tempMan = new SpriteSheet(animMan[3], 72, 121);
            this.right = new Animation(tempMan, 100);
        } else if (this.citizenType == 2) {
            Image citizenWoman = new Image("data/character/citizen_woman.png");
            Image[] animWoman = new Image[4];
            int i = 0;
            while (i < 4) {
                animWoman[i] = citizenWoman.getSubImage(0, i * 121, 72, 121);
                ++i;
            }
            SpriteSheet tempWoman = new SpriteSheet(animWoman[0], 72, 121);
            this.up = new Animation(tempWoman, 100);
            tempWoman = new SpriteSheet(animWoman[1], 72, 121);
            this.down = new Animation(tempWoman, 100);
            tempWoman = new SpriteSheet(animWoman[2], 72, 121);
            this.left = new Animation(tempWoman, 100);
            tempWoman = new SpriteSheet(animWoman[3], 72, 121);
            this.right = new Animation(tempWoman, 100);
        } else if (this.citizenType == 3) {
            this.startPos = this.position.y;
            Image citizenChild = new Image("data/character/citizen_child.png");
            Image[] animChild = new Image[2];
            int i = 0;
            while (i < 2) {
                animChild[i] = citizenChild.getSubImage(0, i * 80, citizenChild.getWidth(), 80);
                ++i;
            }
            SpriteSheet tempChild = new SpriteSheet(animChild[0], 50, 80);
            this.up = new Animation(tempChild, 100);
            tempChild = new SpriteSheet(animChild[1], 50, 80);
            this.down = new Animation(tempChild, 100);
            this.left = this.up;
            this.right = this.down;
            this.up.setPingPong(true);
            this.down.setPingPong(true);
        } else if (this.citizenType == 4) {
            Image citizenCripple = new Image("data/character/citizen_crippledMan.png");
            SpriteSheet tempCripple = new SpriteSheet(citizenCripple, 72, 121);
            this.up = this.down = new Animation(tempCripple, 100);
            this.left = this.down;
            this.right = this.down;
        }
        this.collision = new Rectangle(8.0f, this.up.getHeight() - (this.up.getWidth() - 16), this.up.getWidth() - 16, this.up.getWidth() - 16);
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (this.startDialog && this.dialog != null) {
            this.startDialog = false;
            ((GamePlay)game.getState(1)).startDialog(this.dialog);
            return;
        }
        super.update(container, game, delta);
        switch (this.charState) {
            case Moving: {
                int randomDirection;
                if (this.citizenType == 1 || this.citizenType == 2) {
                    randomDirection = 1 + (int)(Math.random() * 4.0);
                    if (this.waitTime <= 0) {
                        if (randomDirection == 1) {
                            this.direction = Direction.Right;
                        } else if (randomDirection == 2) {
                            this.direction = Direction.Left;
                        } else if (randomDirection == 3) {
                            this.direction = Direction.Down;
                        } else if (randomDirection == 4) {
                            this.direction = Direction.Up;
                        }
                        this.waitTime = 4000;
                    } else {
                        this.waitTime -= delta;
                    }
                }
                if (this.citizenType == 3) {
                    if (this.waitTime <= 0) {
                        randomDirection = 1 + (int)(Math.random() * 2.0);
                        if (randomDirection == 1 && this.position.y >= this.startPos - 64.0f) {
                            this.startMoving(Direction.Up);
                            this.waitTime = 1000;
                        } else if (randomDirection == 2 && this.position.y <= this.startPos + 64.0f) {
                            this.startMoving(Direction.Down);
                            this.waitTime = 1000;
                        }
                    } else {
                        this.waitTime -= delta;
                    }
                }
                if (this.citizenType != 4) break;
                this.direction = Direction.Down;
                break;
            }
        }
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        if (this.dialogID != -1) {
            Dialog.usedDialogs.remove((Object)this.dialogID);
        }
        if (dialog != null) {
            this.dialogID = dialog.getId();
            Dialog.usedDialogs.add(this.dialogID);
        } else {
            this.dialogID = -1;
        }
    }

    public int getDialogID() {
        return this.dialogID;
    }

    public void setDialogID(int dialogID) {
        if (this.dialogID != -1) {
            Dialog.usedDialogs.remove((Object)this.dialogID);
        }
        this.dialogID = dialogID;
        if (this.dialogID != -1) {
            Dialog.usedDialogs.add(this.dialogID);
        }
    }

    @Override
    public int getCollisionType() {
        return 0;
    }

    public void startDialog() {
        this.startDialog = true;
    }
}

