/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.character;

import game.core.Constants;
import game.core.mechanics.Direction;
import game.core.mechanics.character.Enemy;
import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.WeaponCollisionData;
import game.core.mechanics.dialog.Dialog;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.state.StateBasedGame;

public class BigGuard
extends Enemy {
    private static final int WIDTH = 152;
    private static final int HEIGHT = 151;
    private static final int WALK_ANIM_SPEED = 200;
    private static final int ATTACK_ANIM_SPEED = 150;
    private int weaponDamage;
    private Shape weaponCollision;
    public Rectangle bossArea = new Rectangle(0.0f, 0.0f, 2400.0f, 1230.0f);
    private static final int CHAIN_BALLS = 10;
    private Animation attackUp;
    private Animation attackDown;
    private Animation attackLeft;
    private Animation attackRight;
    private Animation roundUp;
    private Animation roundDown;
    private Animation roundLeft;
    private Animation roundRight;
    private Image weapon;
    private Image chain;
    private Image[] head;
    private int currentHead = 0;
    private float headOffset = 17.0f;
    private boolean active = false;
    private Point2D.Float weaponPos = new Point2D.Float();
    private float weaponAngle = 0.0f;
    private static final float NORMAL_WEAPON_DISTANCE = 150.0f;
    private static final float NORMAL_WEAPON_SPEED = 0.35f;
    private float weaponDistance = 150.0f;
    private float weaponSpeed = 0.35f;
    private WeaponCollisionData weaponData;
    private Point2D.Float weaponCenter = new Point2D.Float();
    private float throwX = 0.0f;
    private float throwY = 0.0f;
    private static final float MAX_THROW_DISTANCE = 800.0f;
    private static final int THROWSPEED = 3000;
    private static final float AREA_THROW_SPEED = 0.3f;
    private boolean pullBack = false;
    private boolean thrown = false;
    private float angleIncrease = 0.0f;
    private float throwAngle = 0.0f;
    private boolean expand = true;
    private static final float MAX_ROUND_DISTANCE = 400.0f;
    private static final float DISTANCE_INCREASE = 0.3f;
    private static final float ROUND_SPEED = 0.6f;
    private static final int DEFAULT_WAIT = 600;
    private int waitTime = 600;
    private AttackPhase phase = AttackPhase.Normal;
    private int nextPhase = 3000;
    private Dialog dialog;
    private int dialogID = -1;

    public int getDialogID() {
        return this.dialogID;
    }

    public Dialog getBossDialog() {
        return this.dialog;
    }

    public void setBossDialog(Dialog bossDialog) {
        this.dialog = bossDialog;
        if (this.dialogID != -1) {
            Dialog.usedDialogs.remove(this.dialogID);
        }
        if (this.dialog != null) {
            this.dialogID = this.dialog.getId();
            Dialog.usedDialogs.add(this.dialogID);
        } else {
            this.dialogID = -1;
        }
    }

    public void setDialogID(int dialogID) {
        if (this.dialogID != -1) {
            Dialog.usedDialogs.remove(this.dialogID);
        }
        this.dialogID = dialogID;
        if (this.dialogID != -1) {
            Dialog.usedDialogs.add(this.dialogID);
        }
        this.dialog = null;
    }

    public Rectangle getBossArea() {
        return this.bossArea;
    }

    public Rectangle getNormalizedBossArea() {
        Shape trans = this.bossArea.transform(Transform.createTranslateTransform(this.position.x - this.bossArea.getCenterX(), this.position.y - this.bossArea.getCenterY()));
        return new Rectangle(trans.getMinX(), trans.getMinY(), trans.getWidth(), trans.getHeight());
    }

    private boolean isMorningStarDrawable() {
        return this.charState != GameCharacter.CharacterState.Alert && this.charState != GameCharacter.CharacterState.Dead && this.charState != GameCharacter.CharacterState.Hit && this.charState != GameCharacter.CharacterState.Waiting;
    }

    private void drawMorningStar(float x, float y) {
        if (!this.isMorningStarDrawable()) {
            return;
        }
        float disX = (this.weaponPos.x - this.weaponCenter.x) / 10.0f + 2.0f;
        float disY = (this.weaponPos.y - this.weaponCenter.y) / 10.0f + 2.0f;
        int i = 1;
        while (i < 11) {
            this.chain.draw(this.weaponCenter.x + disX * (float)i - x - (float)(this.chain.getWidth() / 2), this.weaponCenter.y - y - (float)(this.chain.getHeight() / 2) + disY * (float)i);
            ++i;
        }
        this.weapon.draw(this.weaponPos.x - x - this.weaponCollision.getCenterX(), this.weaponPos.y - y - this.weaponCollision.getCenterY());
    }

    @Override
    public void draw(float x, float y) {
        if (this.weaponPos.y < this.position.y && this.isMorningStarDrawable()) {
            this.drawMorningStar(x, y);
        }
        Image headImage = this.head[this.currentHead];
        headImage.draw(this.position.x - x - (float)(headImage.getWidth() / 2), this.position.y - y - 151.0f - this.headOffset);
        super.draw(x, y);
        if (!(this.charState != GameCharacter.CharacterState.Custom || this.blinking && this.blink >= 100)) {
            if (this.blinking && this.blink > 100) {
                return;
            }
            if (this.phase == AttackPhase.Round) {
                switch (this.direction) {
                    case Up: {
                        this.roundUp.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                        break;
                    }
                    case Down: {
                        this.roundDown.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                        break;
                    }
                    case Left: {
                        this.roundLeft.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                        break;
                    }
                    case Right: {
                        this.roundRight.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                    }
                }
            } else {
                switch (this.direction) {
                    case Up: {
                        this.attackUp.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                        break;
                    }
                    case Down: {
                        this.attackDown.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                        break;
                    }
                    case Left: {
                        this.attackLeft.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                        break;
                    }
                    case Right: {
                        this.attackRight.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                    }
                }
            }
        }
        if (this.weaponPos.y >= this.position.y && this.isMorningStarDrawable()) {
            this.drawMorningStar(x, y);
        }
    }

    private void lookAtHero(Point2D.Float heroPos) {
        float disX = heroPos.x - this.position.x;
        float disY = heroPos.y - this.position.y;
        if (disX == 0.0f) {
            disX = 0.1f;
        }
        float k = disY / disX;
        this.headOffset = this.direction == Direction.Up || this.direction == Direction.Down ? 11.0f : 17.0f;
        if (disX < 0.0f) {
            this.currentHead = (double)k > 1.5 ? 5 : ((double)k > 0.5 ? 6 : ((double)k < -1.5 ? 1 : ((double)k < -0.5 ? 0 : 7)));
        } else if (disX > 0.0f) {
            this.currentHead = (double)k > 1.5 ? 1 : ((double)k > 0.5 ? 2 : ((double)k < -1.5 ? 5 : ((double)k < -0.5 ? 4 : 3)));
        }
    }

    private void updateWeaponCollision() {
        if (this.isMorningStarDrawable()) {
            this.weaponData.setNormalCollisionShape(this.weaponCollision.transform(Transform.createTranslateTransform(this.weaponPos.x - this.weaponCollision.getCenterX(), this.weaponPos.y - this.weaponCollision.getCenterY())));
        } else {
            this.weaponData.setNormalCollisionShape(Constants.EMPTY_COLLISION);
        }
    }

    private void updateWeaponCenter() {
        this.weaponCenter.x = this.position.x;
        this.weaponCenter.y = this.position.y - 50.0f;
        if (this.phase == AttackPhase.Round) {
            this.weaponCenter.y -= 50.0f;
        }
        switch (this.direction) {
            case Up: {
                this.weaponCenter.x += 20.0f;
                break;
            }
            case Down: {
                this.weaponCenter.x -= 20.0f;
                break;
            }
            case Left: {
                this.weaponCenter.x -= 30.0f;
                break;
            }
            case Right: {
                this.weaponCenter.x += 30.0f;
            }
        }
    }

    private void updateWeaponRotation(int delta) {
        this.weaponAngle += this.weaponSpeed * (float)delta + 360.0f;
        this.weaponAngle %= 360.0f;
        double rad = Math.toRadians(this.weaponAngle);
        this.weaponPos.x = this.weaponCenter.x + (float)(Math.cos(rad) * (double)this.weaponDistance);
        this.weaponPos.y = this.weaponCenter.y + (float)(Math.sin(rad) * (double)this.weaponDistance);
    }

    private void updateWeaponThrow(int delta) {
        if (this.weaponDistance > 0.0f && !this.thrown) {
            this.weaponDistance -= (float)delta * 0.2f;
            this.updateWeaponRotation(delta);
        } else {
            this.thrown = true;
            if (!this.pullBack) {
                this.weaponPos.x += this.throwX * (float)delta;
                this.weaponPos.y += this.throwY * (float)delta;
                if (this.weaponPos.distance(this.weaponCenter) >= 800.0) {
                    this.pullBack = true;
                }
            } else {
                this.weaponPos.x -= this.throwX * (float)delta;
                this.weaponPos.y -= this.throwY * (float)delta;
                if (this.weaponPos.distance(this.weaponCenter) <= 150.0) {
                    this.resetPhase();
                }
            }
        }
    }

    private void resetAttackAnimations() {
        this.attackDown.restart();
        this.attackUp.restart();
        this.attackRight.restart();
        this.attackLeft.restart();
        this.roundDown.restart();
        this.roundUp.restart();
        this.roundLeft.restart();
        this.roundRight.restart();
    }

    private void updateWeaponRound(int delta) {
        if (this.expand && this.waitTime <= 0) {
            this.weaponDistance += 0.3f * (float)delta;
        } else if (!this.expand) {
            this.weaponDistance -= 0.3f * (float)delta;
        } else {
            this.waitTime -= delta;
        }
        if (this.expand && this.weaponPos.distance(this.weaponCenter) >= 400.0 && this.waitTime <= 0) {
            this.expand = false;
        } else if (!this.expand && this.weaponPos.distance(this.weaponCenter) <= 150.0) {
            this.resetPhase();
        }
        this.updateWeaponRotation(delta);
    }

    private void updateWeaponAreaThrow(int delta, Point2D.Float heroPos) {
        if (this.path.getLength() == this.currentStep + 1) {
            if (!this.thrown) {
                this.charState = GameCharacter.CharacterState.Custom;
                if (heroPos.x < this.position.x) {
                    this.direction = Direction.Left;
                    if (heroPos.y > this.position.y) {
                        this.throwAngle = 20.0f;
                    } else {
                        this.throwAngle = 340.0f;
                        this.weaponSpeed *= -1.0f;
                    }
                } else {
                    this.direction = Direction.Right;
                    if (heroPos.y < this.position.y) {
                        this.throwAngle = 200.0f;
                    } else {
                        this.throwAngle = 160.0f;
                        this.weaponSpeed *= -1.0f;
                    }
                }
                this.thrown = true;
                this.updateWeaponRotation(delta);
                this.waitTime = 600;
            } else if (this.waitTime <= 0) {
                float error = 4.0f;
                if (this.weaponAngle >= this.throwAngle - error && this.weaponAngle <= this.throwAngle + error && !this.pullBack) {
                    this.pullBack = true;
                    this.weaponSpeed = 0.3f;
                    switch ((int)this.throwAngle) {
                        case 20: {
                            this.throwAngle = 180.0f;
                            this.angleIncrease = this.weaponSpeed;
                            break;
                        }
                        case 340: {
                            this.throwAngle = 180.0f;
                            this.angleIncrease = -this.weaponSpeed;
                            break;
                        }
                        case 200: {
                            this.throwAngle = 0.0f;
                            this.angleIncrease = this.weaponSpeed;
                            break;
                        }
                        case 160: {
                            this.throwAngle = 0.0f;
                            this.angleIncrease = -this.weaponSpeed;
                        }
                    }
                } else if (this.pullBack) {
                    if (this.weaponAngle >= this.throwAngle - error && this.weaponAngle <= this.throwAngle + error) {
                        this.weaponSpeed = 1.6f;
                        if (this.weaponDistance <= 150.0f) {
                            this.resetPhase();
                        } else {
                            this.weaponDistance -= (float)delta * this.weaponSpeed;
                        }
                    } else {
                        this.weaponAngle += (float)delta * this.angleIncrease;
                        this.weaponAngle %= 360.0f;
                        double dist = heroPos.distance(this.position);
                        if ((double)this.weaponDistance < dist - (double)error) {
                            this.weaponDistance += 1.0f * (float)delta;
                        } else if ((double)this.weaponDistance > dist + (double)error) {
                            this.weaponDistance -= 1.0f * (float)delta;
                        }
                    }
                    double rad = Math.toRadians(this.weaponAngle);
                    this.weaponPos.x = this.weaponCenter.x + (float)(Math.cos(rad) * (double)this.weaponDistance);
                    this.weaponPos.y = this.weaponCenter.y + (float)(Math.sin(rad) * (double)this.weaponDistance);
                } else {
                    this.updateWeaponRotation(delta);
                }
            } else {
                this.waitTime -= delta;
                this.updateWeaponRotation(delta);
            }
        } else {
            this.updateWeaponRotation(delta);
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (game == null) {
            return;
        }
        if (this.active) {
            super.update(container, game, delta);
        }
        Hero h = ((GamePlay)game.getState(1)).getHero();
        Point2D.Float heroPos = h.getPosition();
        this.lookAtHero(heroPos);
        if (this.charState == GameCharacter.CharacterState.Hit || this.charState == GameCharacter.CharacterState.Dead) {
            this.updateWeaponCollision();
            if (this.phase != AttackPhase.Normal) {
                GameCharacter.CharacterState old = this.charState;
                this.resetPhase();
                this.charState = old;
            }
            super.update(container, game, delta);
            return;
        }
        switch (this.phase) {
            case Normal: {
                if (this.isMorningStarDrawable()) {
                    this.updateWeaponCenter();
                    this.updateWeaponRotation(delta);
                }
                this.nextPhase -= delta;
                if (this.nextPhase > 0) break;
                if (Math.random() < 0.333333) {
                    this.phase = AttackPhase.Throw;
                    float distance = (float)this.weaponCenter.distance(this.position);
                    float distX = heroPos.x - this.position.x;
                    float distY = heroPos.y - this.position.y;
                    distX = 800.0f * distX / distance;
                    distY = 800.0f * distY / distance;
                    this.throwX = distX / 3000.0f;
                    this.throwY = distY / 3000.0f;
                    this.charState = GameCharacter.CharacterState.Custom;
                } else if (Math.random() < 0.33333) {
                    this.phase = AttackPhase.Round;
                    this.weaponSpeed = 0.6f;
                    this.charState = GameCharacter.CharacterState.Custom;
                } else if (Math.random() < 0.33333) {
                    this.weaponSpeed = 0.6f;
                    GamePlay gP = (GamePlay)game.getState(1);
                    Point2D.Float pathPoint = heroPos.x > this.position.x ? new Point2D.Float(gP.getViewport().getX() + this.collision.getWidth(), gP.getViewport().getCenterY()) : new Point2D.Float(gP.getViewport().getMaxX() - this.collision.getWidth(), gP.getViewport().getCenterY());
                    gP.getCollisionManager().getPath(this.position, pathPoint, this, this.path);
                    this.getNewPath = 500;
                    this.phase = AttackPhase.AreaThrow;
                }
                this.resetAttackAnimations();
                break;
            }
            case Throw: {
                this.updateWeaponThrow(delta);
                break;
            }
            case Round: {
                this.updateWeaponRound(delta);
                break;
            }
            case AreaThrow: {
                this.getNewPath = 500;
                this.updateWeaponAreaThrow(delta, heroPos);
            }
        }
        this.updateWeaponCenter();
        this.updateWeaponCollision();
        if (!this.active && this.getNormalizedBossArea().contains(h.getNormalCollisionShape())) {
            this.active = true;
            ((GamePlay)game.getState(1)).startBossfight(this);
            this.charState = GameCharacter.CharacterState.Standing;
        }
    }

    private void resetPhase() {
        this.pullBack = false;
        this.thrown = false;
        this.charState = GameCharacter.CharacterState.Moving;
        this.phase = AttackPhase.Normal;
        this.nextPhase = (int)(2000.0 + Math.random() * 4000.0);
        this.weaponDistance = 150.0f;
        this.weaponSpeed = 0.35f;
        this.expand = true;
        this.waitTime = 600;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        Image tmp = new Image("data/character/BigGuard.png");
        Image[] anims = new Image[12];
        int i = 0;
        while (i < anims.length) {
            anims[i] = tmp.getSubImage(0, i * 151, tmp.getWidth(), 151);
            ++i;
        }
        if (game != null && this.dialogID != -1) {
            GamePlay g = (GamePlay)game.getState(1);
            this.dialog = g.getMapData().getDialogs().get(this.dialogID);
            if (this.dialog != null) {
                this.dialog.setType(Dialog.SpeakerType.BigGuard);
                this.dialog.init();
            }
        }
        SpriteSheet sheet = new SpriteSheet(anims[1], 152, 151);
        this.up = new Animation(sheet, 200);
        sheet = new SpriteSheet(anims[0], 152, 151);
        this.down = new Animation(sheet, 200);
        sheet = new SpriteSheet(anims[2], 152, 151);
        this.left = new Animation(sheet, 200);
        sheet = new SpriteSheet(anims[3], 152, 151);
        this.right = new Animation(sheet, 200);
        this.up.setPingPong(true);
        this.down.setPingPong(true);
        this.left.setPingPong(true);
        this.right.setPingPong(true);
        sheet = new SpriteSheet(anims[5], 152, 151);
        this.attackUp = new Animation(sheet, 150);
        sheet = new SpriteSheet(anims[4], 152, 151);
        this.attackDown = new Animation(sheet, 150);
        sheet = new SpriteSheet(anims[6], 152, 151);
        this.attackLeft = new Animation(sheet, 150);
        sheet = new SpriteSheet(anims[7], 152, 151);
        this.attackRight = new Animation(sheet, 150);
        this.attackUp.setLooping(false);
        this.attackDown.setLooping(false);
        this.attackLeft.setLooping(false);
        this.attackRight.setLooping(false);
        sheet = new SpriteSheet(anims[8], 152, 151);
        this.roundUp = new Animation(sheet, 150);
        sheet = new SpriteSheet(anims[9], 152, 151);
        this.roundDown = new Animation(sheet, 150);
        sheet = new SpriteSheet(anims[10], 152, 151);
        this.roundLeft = new Animation(sheet, 150);
        sheet = new SpriteSheet(anims[11], 152, 151);
        this.roundRight = new Animation(sheet, 150);
        this.roundUp.setLooping(false);
        this.roundDown.setLooping(false);
        this.roundLeft.setLooping(false);
        this.roundRight.setLooping(false);
        this.head = new Image[8];
        Image tmpHead = new Image("data/character/BigGuard_Head.png");
        int i2 = 0;
        while (i2 < this.head.length) {
            this.head[i2] = tmpHead.getSubImage(i2 * 82, 0, 82, tmpHead.getHeight());
            ++i2;
        }
        this.weapon = new Image("data/character/morningStar.png");
        this.weaponCollision = new Rectangle(0.0f, 0.0f, this.weapon.getWidth(), this.weapon.getHeight());
        this.chain = new Image("data/character/chain.png");
        this.speed = 0.1f;
        this.collision = new Rectangle(30.0f, 80.0f, 92.0f, 92.0f);
        this.weaponDamage = 3;
        this.bodyDamage = 2;
        this.maxHP = (short)10;
        this.aktHP = (short)10;
        this.weaponData = new WeaponCollisionData(this.weaponDamage, this, Constants.EMPTY_COLLISION);
    }

    @Override
    public WeaponCollisionData getWeaponCollision() {
        return this.weaponData;
    }

    public void resetBoss() {
        this.aktHP = this.maxHP;
        this.active = false;
        this.charState = GameCharacter.CharacterState.Waiting;
    }

    private static enum AttackPhase {
        Normal,
        Round,
        Throw,
        AreaThrow;

    }
}

