/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;

public class Weather {
    private int nextWeatherPhase = 30000;
    public WeatherPhase condition = WeatherPhase.Clear;
    private Music rainSound;
    private Sound thunder;
    private Image rainDrop;
    private ArrayList<Point2D.Float> rainDrops = new ArrayList();
    private static Color fogColor = new Color(0.8f, 0.8f, 0.8f, 0.3f);
    private static Color rainColor = new Color(0.3f, 0.3f, 0.3f, 0.3f);
    private static Color clearColor = new Color(1, 1, 1, 0);
    private static Color thunderColor = new Color(1.0f, 1.0f, 1.0f, 0.7f);
    private int thunderTimer = 5000;
    private boolean lightning = false;
    private static final int MAX_RAINDROPS = 300;
    private static final int RAIN_FADE = 3000;
    private int spawnRain = 10;
    private static Point2D.Float rainSpeed = new Point2D.Float(0.25f, 0.75f);
    private Random rand = new Random(System.currentTimeMillis());
    private static final float COLOR_CHANGE = 6.0E-5f;
    private static final float THUNDER_CHANGE = 0.001f;
    private Color currentColor = new Color(1, 1, 1, 0);

    public WeatherPhase getCondition() {
        return this.condition;
    }

    public void draw(float x, float y, Graphics g) {
        x = (float)((double)x * 0.5);
        y = (float)((double)y * 0.5);
        for (Point2D.Float point : this.rainDrops) {
            float rX = point.x - x;
            float rY = point.y - y;
            while (rX < 0.0f) {
                rX += 1280.0f;
            }
            while (rY < 0.0f) {
                rY += 720.0f;
            }
            this.rainDrop.draw(rX, rY);
        }
        g.setColor(this.currentColor);
        g.fillRect(0.0f, 0.0f, 1280.0f, 720.0f);
    }

    public void init() throws SlickException {
        this.rainDrop = new Image("data/weather/raindrop.png");
        this.rainSound = new Music("data/sound/sfx/rain.ogg");
        this.thunder = new Sound("data/sound/sfx/thunder.ogg");
    }

    private float checkChannel(int delta, float oldChannel, float newChannel) {
        float change = 6.0E-5f;
        if (this.lightning) {
            change = 0.001f;
        }
        if (oldChannel < newChannel) {
            if ((oldChannel += change * (float)delta) > newChannel) {
                oldChannel = newChannel;
            }
        } else if (oldChannel > newChannel && (oldChannel -= change * (float)delta) < newChannel) {
            oldChannel = newChannel;
        }
        return oldChannel;
    }

    private void updateColor(int delta, Color newColor) {
        this.currentColor.a = this.checkChannel(delta, this.currentColor.a, newColor.a);
        this.currentColor.r = this.checkChannel(delta, this.currentColor.r, newColor.r);
        this.currentColor.g = this.checkChannel(delta, this.currentColor.g, newColor.g);
        this.currentColor.b = this.checkChannel(delta, this.currentColor.b, newColor.b);
        if (this.lightning && this.currentColor.equals(newColor)) {
            this.lightning = false;
        }
    }

    private void removeRaindrops(int delta) {
        if (this.rainDrops.size() > 0) {
            if (this.spawnRain <= 0) {
                this.rainDrops.remove(0);
                this.spawnRain += 10;
            } else {
                this.spawnRain -= delta;
            }
        }
    }

    public boolean isRainPlaying() {
        return this.rainSound.playing();
    }

    public void update(int delta) {
        switch (this.condition) {
            case Rain: {
                if (this.rainDrops.size() < 300) {
                    if (this.spawnRain <= 0) {
                        float x = this.rand.nextFloat() * 1280.0f;
                        float y = this.rand.nextFloat() * 720.0f;
                        this.rainDrops.add(new Point2D.Float(x, y));
                        this.spawnRain += 10;
                    } else {
                        this.spawnRain -= delta;
                    }
                }
                this.lightning = true;
                this.thunderTimer -= delta;
                if (this.thunderTimer <= 0) {
                    this.thunderTimer = this.rand.nextInt(7000) + 3000;
                    this.thunder.play();
                    this.currentColor.a = Weather.thunderColor.a;
                    this.currentColor.r = Weather.thunderColor.r;
                    this.currentColor.g = Weather.thunderColor.g;
                    this.currentColor.b = Weather.thunderColor.b;
                }
                this.updateColor(delta, rainColor);
                break;
            }
            case Fog: {
                this.updateColor(delta, fogColor);
                this.removeRaindrops(delta);
                break;
            }
            default: {
                this.updateColor(delta, clearColor);
                this.removeRaindrops(delta);
            }
        }
        int i = 0;
        while (i < this.rainDrops.size()) {
            Point2D.Float p = this.rainDrops.get(i);
            p.x += Weather.rainSpeed.x * (float)delta;
            p.y += Weather.rainSpeed.x * (float)delta;
            if (p.x > 1280.0f || p.y > 720.0f) {
                p.x %= 1280.0f;
                p.y %= 720.0f;
            }
            ++i;
        }
        if (this.nextWeatherPhase <= 0 && !this.lightning) {
            switch (this.rand.nextInt(2)) {
                case 0: {
                    this.condition = WeatherPhase.Clear;
                    this.rainSound.fade(3000, 0.0f, true);
                    break;
                }
                case 1: {
                    this.condition = WeatherPhase.Rain;
                    this.rainSound.loop(1.0f, 0.0f);
                    this.rainSound.fade(3000, 1.0f, false);
                }
            }
            this.nextWeatherPhase = 30000 + this.rand.nextInt(15000);
        }
        this.nextWeatherPhase -= delta;
    }

    public static enum WeatherPhase {
        Clear,
        Rain,
        Fog;

    }
}

