/*
 * Decompiled with CFR 0.152.
 */
package game.core;

import game.core.mechanics.IGameEntity;
import java.awt.geom.Point2D;
import org.newdawn.slick.geom.Rectangle;

public class Viewport {
    private Point2D.Float position = new Point2D.Float();
    private State state;
    private Rectangle area;
    private IGameEntity follow = null;
    private float incX = 0.0f;
    private float incY = 0.0f;
    private int currentPan = 0;

    public Viewport(IGameEntity follow) {
        this.follow = follow;
        this.state = State.Follow;
    }

    public Point2D.Float getPosition() {
        return this.position;
    }

    public int getIX() {
        return (int)this.position.x;
    }

    public int getIY() {
        return (int)this.position.y;
    }

    public float getX() {
        return this.position.x;
    }

    public float getY() {
        return this.position.y;
    }

    public float getCenterX() {
        return this.position.x + 640.0f;
    }

    public float getCenterY() {
        return this.position.y + 360.0f;
    }

    public float getMaxX() {
        return this.position.x + 1280.0f;
    }

    public boolean isPanning() {
        return this.state == State.Pan;
    }

    public void panAndFollow(float x, float y, int millis, IGameEntity follow) {
        this.panAndStop(new Point2D.Float(x, y), millis);
        this.follow = follow;
    }

    public void panAndFollow(Point2D.Float pointTo, int millis, IGameEntity follow) {
        this.panAndStop(pointTo, millis);
        this.follow = follow;
    }

    public void panAndStop(Point2D.Float pointTo, int millis) {
        this.resetStates();
        this.incX = (pointTo.x - this.position.x) / (float)millis;
        this.incY = (pointTo.y - this.position.y) / (float)millis;
        this.currentPan = millis;
        this.state = State.Pan;
    }

    public void followEntity(IGameEntity follow) {
        this.resetStates();
        if (follow.getPosition().x - 640.0f != this.position.x || follow.getPosition().y - 360.0f != this.position.y) {
            this.panAndFollow(follow.getPosition().x - 640.0f, follow.getPosition().y - 360.0f, 300, follow);
        } else {
            this.follow = follow;
            this.state = State.Follow;
        }
    }

    public void followEntityInArea(IGameEntity follow, Rectangle area) {
        this.resetStates();
        float panX = -1.0f;
        float panY = -1.0f;
        if (this.position.x < area.getMinX()) {
            panX = area.getMinX();
        } else if (this.position.x + 1280.0f > area.getMaxX()) {
            panX = area.getMaxX() - 1280.0f;
        }
        if (this.position.y < area.getMinY()) {
            panY = area.getMinY();
        } else if (this.position.y + 720.0f > area.getMaxY()) {
            panY = area.getMaxY() - 720.0f;
        }
        if (panX == -1.0f && panY == -1.0f) {
            this.follow = follow;
            this.state = State.Area;
        } else if (panX == -1.0f && panY != -1.0f) {
            this.panAndFollow(this.position.x, panY, 300, follow);
        } else if (panX != -1.0f && panY == -1.0f) {
            this.panAndFollow(panX, this.position.y, 300, follow);
        } else {
            this.panAndFollow(panX, panY, 300, follow);
        }
        this.area = area;
    }

    private void resetStates() {
        this.follow = null;
        this.area = null;
        this.currentPan = 0;
        this.incX = 0.0f;
        this.incY = 0.0f;
    }

    public void update(int delta) {
        switch (this.state) {
            case Follow: {
                this.position.x = this.follow.getPosition().x - 640.0f;
                this.position.y = this.follow.getPosition().y - 360.0f;
                break;
            }
            case Stationary: {
                break;
            }
            case Area: {
                this.position.x = this.follow.getPosition().x - 640.0f < this.area.getMinX() ? this.area.getMinX() : (this.follow.getPosition().x + 640.0f > this.area.getMaxX() ? this.area.getMaxX() - 1280.0f : this.follow.getPosition().x - 640.0f);
                if (this.follow.getPosition().y - 360.0f < this.area.getMinY()) {
                    this.position.y = this.area.getMinY();
                    break;
                }
                if (this.follow.getPosition().y + 360.0f > this.area.getMaxY()) {
                    this.position.y = this.area.getMaxY() - 720.0f;
                    break;
                }
                this.position.y = this.follow.getPosition().y - 360.0f;
                break;
            }
            case Pan: {
                this.position.x += this.incX * (float)delta;
                this.position.y += this.incY * (float)delta;
                this.currentPan -= delta;
                if (this.currentPan > 0) break;
                if (this.follow != null && this.area != null) {
                    this.state = State.Area;
                    break;
                }
                if (this.follow == null) break;
                this.state = State.Follow;
            }
        }
    }

    private static enum State {
        Follow,
        Area,
        Pan,
        Stationary;

    }
}

