/*
 * Decompiled with CFR 0.152.
 */
package game.core;

import editor.xml.ConverterAnimation;
import editor.xml.ConverterCharacter;
import editor.xml.ConverterDestructible;
import editor.xml.ConverterDialog;
import editor.xml.ConverterEnemy;
import editor.xml.ConverterMoveable;
import editor.xml.ConverterTrigger;
import editor.xml.ConverterUsable;
import editor.xml.IXmlObjectConverter;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.character.Enemy;
import game.core.mechanics.dialog.Dialog;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.tiled.TiledMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MapData {
    private TiledMap map;
    private String mapLocation;
    private String xmlLocation;
    private int objectLayer = 0;
    private int collisionLayer = 0;
    private Point heroStart = new Point();
    private IGameEntity[][] entities;
    private String bgmPath;
    private HashMap<String, IXmlObjectConverter> converter = new HashMap();
    private ConverterDialog dialogConverter;
    private HashMap<Integer, Dialog> dialogs;

    public MapData() {
        LinkedList<IXmlObjectConverter> tmp = new LinkedList<IXmlObjectConverter>();
        tmp.add(new ConverterDestructible());
        tmp.add(new ConverterEnemy());
        tmp.add(new ConverterMoveable());
        tmp.add(new ConverterTrigger());
        tmp.add(new ConverterUsable());
        tmp.add(new ConverterCharacter());
        tmp.add(new ConverterAnimation());
        for (IXmlObjectConverter con : tmp) {
            Class[] classArray = con.getObjectTypes();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                this.converter.put(c.getSimpleName(), con);
                ++n2;
            }
        }
        this.dialogConverter = new ConverterDialog();
    }

    public HashMap<Integer, Dialog> getDialogs() {
        return this.dialogs;
    }

    public TiledMap getMap() {
        return this.map;
    }

    public void setMap(TiledMap map) {
        this.map = map;
    }

    public int getObjectLayer() {
        return this.objectLayer;
    }

    public void setObjectLayer(int objectLayer) {
        this.objectLayer = objectLayer;
    }

    public int getCollisionLayer() {
        return this.collisionLayer;
    }

    public void setCollisionLayer(int collisionLayer) {
        this.collisionLayer = collisionLayer;
    }

    public IGameEntity[][] getEntities() {
        return this.entities;
    }

    public void setEntities(IGameEntity[][] entities) {
        this.entities = entities;
    }

    public String getBgm() {
        return this.bgmPath;
    }

    public void setBgm(String bgm) {
        this.bgmPath = bgm;
    }

    public boolean writeXmlMap(String mapLocation) {
        if (mapLocation == null || mapLocation == "") {
            mapLocation = this.xmlLocation;
        }
        if (this.map == null) {
            return false;
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("Map");
            doc.appendChild(root);
            Element file = doc.createElement("File");
            file.setAttribute("Path", this.mapLocation);
            root.appendChild(file);
            Element layer = doc.createElement("Info");
            layer.setAttribute("Objects", String.valueOf(this.objectLayer));
            layer.setAttribute("Collision", String.valueOf(this.collisionLayer));
            layer.setAttribute("HeroX", String.valueOf(this.heroStart.x));
            layer.setAttribute("HeroY", String.valueOf(this.heroStart.y));
            root.appendChild(layer);
            Element enemies = doc.createElement("Enemies");
            Element objects = doc.createElement("Objects");
            Element dialog = doc.createElement("DialogList");
            root.appendChild(enemies);
            root.appendChild(objects);
            root.appendChild(dialog);
            int x = 0;
            while (x < this.entities.length) {
                int y = 0;
                while (y < this.entities[0].length) {
                    if (this.entities[x][y] != null) {
                        IGameEntity e = this.entities[x][y];
                        String key = e.getClass().getSimpleName();
                        IXmlObjectConverter conv = this.converter.get(key);
                        if (e instanceof Enemy) {
                            enemies.appendChild(conv.getXML(e, doc));
                        } else {
                            objects.appendChild(conv.getXML(e, doc));
                        }
                    }
                    ++y;
                }
                ++x;
            }
            for (Dialog d : this.dialogs.values()) {
                dialog.appendChild(this.dialogConverter.getXML(d, doc));
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(mapLocation));
            transformer.transform(source, result);
            System.out.println("Mapfile saved!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public LinkedList<IGameEntity> loadXmlMap(String mapLocation) throws SAXException, IOException, ParserConfigurationException, DOMException, SlickException {
        File fXmlFile = new File(mapLocation);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        doc.getDocumentElement().normalize();
        LinkedList<IGameEntity> newEntities = new LinkedList<IGameEntity>();
        Node file = doc.getElementsByTagName("File").item(0);
        this.loadTiledMap(file.getAttributes().getNamedItem("Path").getNodeValue());
        Node layer = doc.getElementsByTagName("Info").item(0);
        this.objectLayer = Integer.parseInt(layer.getAttributes().getNamedItem("Objects").getNodeValue());
        this.collisionLayer = Integer.parseInt(layer.getAttributes().getNamedItem("Collision").getNodeValue());
        this.heroStart = new Point(Integer.parseInt(layer.getAttributes().getNamedItem("HeroX").getNodeValue()), Integer.parseInt(layer.getAttributes().getNamedItem("HeroY").getNodeValue()));
        NodeList enemies = doc.getElementsByTagName("Enemies").item(0).getChildNodes();
        int i = 0;
        while (i < enemies.getLength()) {
            if (enemies.item(i).getNodeType() == 1) {
                String key = enemies.item(i).getNodeName();
                IXmlObjectConverter c = null;
                if (this.converter.containsKey(key)) {
                    IGameEntity entity;
                    c = this.converter.get(key);
                    this.entities[(int)(entity.getPosition().x / 64.0f)][(int)(entity.getPosition().y / 64.0f)] = entity = c.getObject(enemies.item(i));
                    newEntities.add(entity);
                }
            }
            ++i;
        }
        NodeList dialogs = doc.getElementsByTagName("DialogList").item(0).getChildNodes();
        int i2 = 0;
        while (i2 < dialogs.getLength()) {
            if (dialogs.item(i2).getNodeType() == 1) {
                Dialog d = this.dialogConverter.getObject(dialogs.item(i2));
                this.dialogs.put(d.getId(), d);
            }
            ++i2;
        }
        NodeList objects = doc.getElementsByTagName("Objects").item(0).getChildNodes();
        int i3 = 0;
        while (i3 < objects.getLength()) {
            if (objects.item(i3).getNodeType() == 1) {
                String key = objects.item(i3).getNodeName();
                IXmlObjectConverter c = null;
                if (this.converter.containsKey(key)) {
                    IGameEntity entity;
                    c = this.converter.get(key);
                    this.entities[(int)(entity.getPosition().x / 64.0f)][(int)(entity.getPosition().y / 64.0f)] = entity = c.getObject(objects.item(i3));
                    newEntities.add(entity);
                }
            }
            ++i3;
        }
        this.xmlLocation = mapLocation;
        return newEntities;
    }

    public void loadTiledMap(String mapLocation) throws SlickException {
        this.mapLocation = mapLocation;
        this.map = new TiledMap(mapLocation);
        this.entities = new IGameEntity[this.map.getWidth()][this.map.getHeight()];
        this.dialogs = new HashMap();
    }

    public boolean reloadMap() throws SlickException {
        if (this.map == null) {
            return false;
        }
        this.map = new TiledMap(this.mapLocation);
        this.updateEntities();
        return true;
    }

    private void updateEntities() {
        IGameEntity[][] newEntities = new IGameEntity[this.map.getWidth()][this.map.getHeight()];
        int x = 0;
        while (x < newEntities.length && x < this.entities.length) {
            int y = 0;
            while (y < newEntities[0].length && y < this.entities[0].length) {
                newEntities[x][y] = this.entities[x][y];
                ++y;
            }
            ++x;
        }
        this.entities = newEntities;
    }

    public Point getHeroStart() {
        return this.heroStart;
    }
}

