/*
 * Decompiled with CFR 0.152.
 */
package editor.xml;

import editor.xml.IXmlObjectConverter;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.objects.Usable;
import game.core.mechanics.objects.usable.Chest;
import game.core.mechanics.objects.usable.Heart;
import game.core.mechanics.objects.usable.Key;
import game.core.mechanics.objects.usable.Potion;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConverterUsable
implements IXmlObjectConverter {
    @Override
    public Class[] getObjectTypes() {
        return new Class[]{Usable.class, Heart.class, Key.class, Potion.class, Chest.class};
    }

    @Override
    public Element getXML(IGameEntity e, Document doc) {
        Element ele = doc.createElement(Usable.class.getSimpleName());
        ele.setAttribute("x", String.valueOf((int)(e.getPosition().x / 64.0f)));
        ele.setAttribute("y", String.valueOf((int)(e.getPosition().y / 64.0f)));
        String type = null;
        if (e instanceof Key) {
            type = "Key";
        } else if (e instanceof Potion) {
            type = "Potion";
        } else if (e instanceof Heart) {
            type = "Heart";
        } else if (e instanceof Chest) {
            type = "Chest";
            String item = "";
            switch (((Chest)e).getItem()) {
                case Heart: {
                    item = "Heart";
                    break;
                }
                case Key: {
                    item = "Key";
                    break;
                }
                case Potion: {
                    item = "Potion";
                }
            }
            ele.setAttribute("item", item);
        }
        ele.setAttribute("type", type);
        return ele;
    }

    @Override
    public IGameEntity getObject(Node xml) {
        int x = Integer.parseInt(xml.getAttributes().getNamedItem("x").getNodeValue());
        int y = Integer.parseInt(xml.getAttributes().getNamedItem("y").getNodeValue());
        String type = xml.getAttributes().getNamedItem("type").getNodeValue();
        Usable u = null;
        switch (type) {
            case "Key": {
                u = new Key(null);
                break;
            }
            case "Potion": {
                u = new Potion(null);
                break;
            }
            case "Heart": {
                u = new Heart(null);
                break;
            }
            case "Chest": {
                switch (xml.getAttributes().getNamedItem("item").getNodeValue()) {
                    case "Key": {
                        u = new Chest(null, Chest.Item.Key);
                        break;
                    }
                    case "Potion": {
                        u = new Chest(null, Chest.Item.Potion);
                        break;
                    }
                    case "Heart": {
                        u = new Chest(null, Chest.Item.Heart);
                    }
                }
                break;
            }
            default: {
                return null;
            }
        }
        u.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
        return u;
    }
}

