/*
 * Decompiled with CFR 0.152.
 */
package editor.xml;

import editor.xml.IXmlObjectConverter;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.objects.Trigger;
import game.core.mechanics.objects.trigger.Checkpoint;
import game.core.mechanics.objects.trigger.DialogTrigger;
import game.core.mechanics.objects.trigger.DoorTrigger;
import game.core.mechanics.objects.trigger.MessageTrigger;
import game.core.mechanics.objects.trigger.OwlTrigger;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConverterTrigger
implements IXmlObjectConverter {
    @Override
    public Class[] getObjectTypes() {
        return new Class[]{Trigger.class, Checkpoint.class, DialogTrigger.class, DoorTrigger.class, OwlTrigger.class, MessageTrigger.class};
    }

    @Override
    public Element getXML(IGameEntity e, Document doc) {
        String type;
        Trigger t = (Trigger)e;
        Element ele = doc.createElement("Trigger");
        ele.setAttribute("x", String.valueOf((int)(e.getPosition().x / 64.0f)));
        ele.setAttribute("y", String.valueOf((int)(e.getPosition().y / 64.0f)));
        ele.setAttribute("width", String.valueOf(e.getCollisionShape().getWidth()));
        ele.setAttribute("height", String.valueOf(e.getCollisionShape().getHeight()));
        ele.setAttribute("automatic", String.valueOf(t.isAutomatic()));
        if (t instanceof Checkpoint) {
            type = "Checkpoint";
        } else if (t instanceof DialogTrigger) {
            type = "Dialog";
            if (((DialogTrigger)t).getDialogID() == -1) {
                return null;
            }
            ele.setAttribute("dialogID", String.valueOf(((DialogTrigger)t).getDialogID()));
        } else if (t instanceof OwlTrigger) {
            OwlTrigger o = (OwlTrigger)t;
            if (o.getDialogID() == -1 || o.getOwlX() == 0 || o.getOwlY() == 0) {
                return null;
            }
            type = "Owl";
            ele.setAttribute("dialogID", String.valueOf(o.getDialogID()));
            ele.setAttribute("owlX", String.valueOf(o.getOwlX()));
            ele.setAttribute("owlY", String.valueOf(o.getOwlY()));
        } else if (t instanceof DoorTrigger) {
            type = "Door";
            ele.setAttribute("doorType", ((DoorTrigger)t).getDoorType().toString());
        } else if (t instanceof MessageTrigger) {
            type = "Message";
            ele.setAttribute("msg", ((MessageTrigger)t).getMessage());
        } else {
            return null;
        }
        ele.setAttribute("type", type);
        return ele;
    }

    @Override
    public IGameEntity getObject(Node xml) {
        int x = Integer.parseInt(xml.getAttributes().getNamedItem("x").getNodeValue());
        int y = Integer.parseInt(xml.getAttributes().getNamedItem("y").getNodeValue());
        float width = Float.parseFloat(xml.getAttributes().getNamedItem("width").getNodeValue());
        float height = Float.parseFloat(xml.getAttributes().getNamedItem("height").getNodeValue());
        boolean automatic = Boolean.parseBoolean(xml.getAttributes().getNamedItem("automatic").getNodeValue());
        String type = xml.getAttributes().getNamedItem("type").getNodeValue();
        Trigger t = null;
        switch (type) {
            case "Checkpoint": {
                t = new Checkpoint(null);
                break;
            }
            case "Dialog": {
                int dialogID = Integer.parseInt(xml.getAttributes().getNamedItem("dialogID").getNodeValue());
                t = new DialogTrigger(null, automatic, dialogID);
                break;
            }
            case "Owl": {
                int owlX = Integer.parseInt(xml.getAttributes().getNamedItem("owlX").getNodeValue());
                int owlY = Integer.parseInt(xml.getAttributes().getNamedItem("owlY").getNodeValue());
                int dialogIDO = Integer.parseInt(xml.getAttributes().getNamedItem("dialogID").getNodeValue());
                t = new OwlTrigger(null, automatic, dialogIDO, owlX, owlY);
                break;
            }
            case "Door": {
                String dType = xml.getAttributes().getNamedItem("doorType").getNodeValue();
                t = dType.equals(DoorTrigger.Type.Wood.toString()) ? new DoorTrigger(null, DoorTrigger.Type.Wood) : new DoorTrigger(null, DoorTrigger.Type.Castle);
                if (((DoorTrigger)t).getDoorType() == DoorTrigger.Type.Wood) {
                    t.setPosition(new Point2D.Float(x * 64, y * 64 + 32));
                    break;
                }
                t.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
                break;
            }
            case "Message": {
                MessageTrigger m = new MessageTrigger(null);
                m.setMessage(xml.getAttributes().getNamedItem("msg").getNodeValue());
                t = m;
                break;
            }
            default: {
                return null;
            }
        }
        if (!(t instanceof DoorTrigger)) {
            t.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
        }
        t.setCollisionHeight(height);
        t.setCollisionWidth(width);
        return t;
    }
}

