/*
 * Decompiled with CFR 0.152.
 */
package editor.xml;

import editor.xml.IXmlObjectConverter;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.objects.Moveable;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConverterMoveable
implements IXmlObjectConverter {
    @Override
    public Class[] getObjectTypes() {
        return new Class[]{Moveable.class};
    }

    @Override
    public Element getXML(IGameEntity e, Document doc) {
        Element ele = doc.createElement("Moveable");
        ele.setAttribute("x", String.valueOf((int)(e.getPosition().x / 64.0f)));
        ele.setAttribute("y", String.valueOf((int)(e.getPosition().y / 64.0f)));
        String type = "";
        switch (((Moveable)e).getType()) {
            case Block: {
                type = "Block";
                break;
            }
            case Rock: {
                type = "Rock";
            }
        }
        ele.setAttribute("type", type);
        ele.setAttribute("rate", String.valueOf(((Moveable)e).getMaxMove()));
        return ele;
    }

    @Override
    public IGameEntity getObject(Node xml) {
        int x = Integer.parseInt(xml.getAttributes().getNamedItem("x").getNodeValue());
        int y = Integer.parseInt(xml.getAttributes().getNamedItem("y").getNodeValue());
        String type = xml.getAttributes().getNamedItem("type").getNodeValue();
        int maxMove = Integer.parseInt(xml.getAttributes().getNamedItem("rate").getNodeValue());
        Moveable m = null;
        switch (type) {
            case "Rock": {
                m = new Moveable(null, Moveable.MoveableType.Rock, maxMove);
                break;
            }
            case "Block": {
                m = new Moveable(null, Moveable.MoveableType.Block, maxMove);
                break;
            }
            default: {
                return null;
            }
        }
        m.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
        return m;
    }
}

