/*
 * Decompiled with CFR 0.152.
 */
package editor.xml;

import editor.xml.IXmlObjectConverter;
import game.core.mechanics.Direction;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.character.Citizen;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConverterCharacter
implements IXmlObjectConverter {
    @Override
    public Class[] getObjectTypes() {
        return new Class[]{Citizen.class};
    }

    @Override
    public Element getXML(IGameEntity e, Document doc) {
        Citizen en = (Citizen)e;
        Element ele = doc.createElement("Citizen");
        ele.setAttribute("x", String.valueOf((int)(e.getPosition().x / 64.0f)));
        ele.setAttribute("y", String.valueOf((int)(e.getPosition().y / 64.0f)));
        ele.setAttribute("direction", String.valueOf((Object)en.getDirection()));
        ele.setAttribute("dialogID", String.valueOf(en.getDialogID()));
        String type = "Citizen";
        ele.setAttribute("type", type);
        ele.setAttribute("sex", Integer.toString(en.getCitizenType()));
        return ele;
    }

    @Override
    public IGameEntity getObject(Node xml) {
        int x = Integer.parseInt(xml.getAttributes().getNamedItem("x").getNodeValue());
        int y = Integer.parseInt(xml.getAttributes().getNamedItem("y").getNodeValue());
        int dialogID = Integer.parseInt(xml.getAttributes().getNamedItem("dialogID").getNodeValue());
        String type = xml.getAttributes().getNamedItem("type").getNodeValue();
        String sex = xml.getAttributes().getNamedItem("sex").getNodeValue();
        String dir = xml.getAttributes().getNamedItem("direction").getNodeValue();
        Citizen e = null;
        switch (type) {
            case "Citizen": {
                switch (sex) {
                    case "1": {
                        e = new Citizen(1, dialogID);
                        break;
                    }
                    case "2": {
                        e = new Citizen(2, dialogID);
                        break;
                    }
                    case "3": {
                        e = new Citizen(3, dialogID);
                        break;
                    }
                    case "4": {
                        e = new Citizen(4, dialogID);
                    }
                }
                break;
            }
            default: {
                return null;
            }
        }
        e.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
        switch (dir) {
            case "Up": {
                e.setDirection(Direction.Up);
                break;
            }
            case "Down": {
                e.setDirection(Direction.Down);
                break;
            }
            case "Left": {
                e.setDirection(Direction.Left);
                break;
            }
            case "Right": {
                e.setDirection(Direction.Right);
                break;
            }
            default: {
                e.setDirection(Direction.Down);
            }
        }
        return e;
    }
}

