/*
 * Decompiled with CFR 0.152.
 */
package editor.history;

import editor.MapRenderer;
import game.core.MapData;
import game.core.mechanics.IGameEntity;
import java.awt.geom.Point2D;

public class Action {
    private IGameEntity object;
    private Point2D.Float oldPosition;
    private ActionType action;

    public Action(IGameEntity object, Point2D.Float oldPosition, ActionType action) {
        this.object = object;
        this.oldPosition = oldPosition;
        this.action = action;
    }

    public void undoAction(MapData data, MapRenderer renderer) {
        int curX = (int)(this.object.getPosition().x / 64.0f);
        int curY = (int)(this.object.getPosition().y / 64.0f);
        int oldX = (int)(this.oldPosition.x / 64.0f);
        int oldY = (int)(this.oldPosition.y / 64.0f);
        switch (this.action) {
            case Create: {
                data.getEntities()[curX][curY] = null;
                renderer.getEntities().remove(this.object);
                break;
            }
            case Move: {
                this.object.setPosition(new Point2D.Float(oldX * 64 + 32, oldY * 64 + 32));
                data.getEntities()[curX][curY] = null;
                data.getEntities()[oldX][oldY] = this.object;
                break;
            }
            case Delete: {
                this.object.setPosition(new Point2D.Float(oldX * 64 + 32, oldY * 64 + 32));
                data.getEntities()[oldX][oldY] = this.object;
                renderer.getEntities().add(this.object);
            }
        }
    }

    public static enum ActionType {
        Create,
        Move,
        Delete;

    }
}

