/*
 * Decompiled with CFR 0.152.
 */
package editor;

import game.core.MapData;
import game.core.mechanics.dialog.Dialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class Notepad
extends JPanel {
    private MapData mapData;
    private Dialog currentDialog = null;
    private int currentText = -1;
    DefaultMutableTreeNode root;
    int currentDialogID = 0;

    public MapData getMapData() {
        return this.mapData;
    }

    public void setMapData(MapData mapData) {
        this.mapData = mapData;
    }

    private DefaultMutableTreeNode getNode(Dialog d) {
        int i = 0;
        while (i < this.root.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            if (d.equals(node.getUserObject())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public Notepad() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.add((Component)panel, "North");
        this.root = new DefaultMutableTreeNode("Dialogs");
        final JTree tPanel = new JTree(this.root);
        tPanel.setEditable(true);
        JScrollPane sPane = new JScrollPane(tPanel);
        sPane.setHorizontalScrollBarPolicy(31);
        sPane.setPreferredSize(new Dimension(250, 1));
        this.add((Component)sPane, "West");
        final JTextPane textPane = new JTextPane();
        this.add((Component)textPane, "Center");
        JButton btnAddText = new JButton("Add Text");
        btnAddText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Notepad.this.currentDialog == null) {
                    return;
                }
                Notepad.this.currentDialog.addDialogText(textPane.getText());
                Notepad.this.getNode(Notepad.this.currentDialog).add(new DefaultMutableTreeNode(textPane.getText()));
                ((DefaultTreeModel)tPanel.getModel()).setRoot(Notepad.this.root);
            }
        });
        panel.add(btnAddText);
        JButton btnAddDialog = new JButton("Add Dialog");
        btnAddDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.currentDialog = new Dialog(-1);
                Notepad.this.mapData.getDialogs().put(Notepad.this.currentDialog.getId(), Notepad.this.currentDialog);
                Notepad.this.root.add(new DefaultMutableTreeNode(Notepad.this.currentDialog));
                ((DefaultTreeModel)tPanel.getModel()).setRoot(Notepad.this.root);
            }
        });
        panel.add(btnAddDialog);
        JSeparator separator = new JSeparator();
        separator.setToolTipText("");
        panel.add(separator);
        JButton btnDeleteText = new JButton("Delete Text");
        btnDeleteText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Notepad.this.currentText == -1) {
                    return;
                }
                Notepad.this.currentDialog.getText().remove(Notepad.this.currentText);
                Notepad.this.getNode(Notepad.this.currentDialog).remove(Notepad.this.currentText);
                ((DefaultTreeModel)tPanel.getModel()).setRoot(Notepad.this.root);
            }
        });
        panel.add(btnDeleteText);
        JButton btnDeleteDialog = new JButton("Delete Dialog");
        btnDeleteDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Notepad.this.currentDialog == null) {
                    return;
                }
                Notepad.this.mapData.getDialogs().remove(Notepad.this.currentDialog);
                Notepad.this.root.remove(Notepad.this.getNode(Notepad.this.currentDialog));
                ((DefaultTreeModel)tPanel.getModel()).setRoot(Notepad.this.root);
            }
        });
        panel.add(btnDeleteDialog);
        JSeparator separator_1 = new JSeparator();
        panel.add(separator_1);
        JButton btnSaveChanges = new JButton("Save Changes");
        panel.add(btnSaveChanges);
        btnSaveChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Notepad.this.currentText == -1 || Notepad.this.currentDialog == null) {
                    return;
                }
                Notepad.this.currentDialog.getText().remove(Notepad.this.currentText);
                Notepad.this.currentDialog.getText().add(Notepad.this.currentText, textPane.getText());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)Notepad.this.getNode(Notepad.this.currentDialog).getChildAt(Notepad.this.currentText);
                node.setUserObject(textPane.getText());
                ((DefaultTreeModel)tPanel.getModel()).setRoot(Notepad.this.root);
            }
        });
        JLabel labelText = new JLabel("");
        this.add((Component)labelText, "South");
        tPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (tPanel.getSelectionPath() == null) {
                    return;
                }
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)tPanel.getSelectionPath().getLastPathComponent();
                if (currentNode == Notepad.this.root) {
                    textPane.setText("");
                    Notepad.this.currentDialog = null;
                    Notepad.this.currentText = -1;
                } else if (currentNode.getUserObject() instanceof Dialog) {
                    Notepad.this.currentDialog = (Dialog)currentNode.getUserObject();
                    textPane.setText("");
                    Notepad.this.currentText = -1;
                } else if (currentNode.getUserObject() instanceof String) {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)currentNode.getParent();
                    Notepad.this.currentDialog = (Dialog)parent.getUserObject();
                    textPane.setText((String)currentNode.getUserObject());
                    Notepad.this.currentText = Notepad.this.currentDialog.getText().indexOf((String)currentNode.getUserObject());
                }
            }
        });
        this.setVisible(true);
    }

    public void getDialogData() {
        this.root.removeAllChildren();
        for (Dialog d : this.mapData.getDialogs().values()) {
            DefaultMutableTreeNode diaNode = new DefaultMutableTreeNode(d);
            for (String text : d.getText()) {
                diaNode.add(new DefaultMutableTreeNode(text));
            }
            this.root.add(diaNode);
        }
    }
}

