/*
 * Decompiled with CFR 0.152.
 */
package editor;

import game.core.mechanics.Direction;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.character.BigGuard;
import game.core.mechanics.character.Hero;
import game.core.mechanics.objects.Trigger;
import game.core.mechanics.objects.trigger.DoorTrigger;
import game.core.mechanics.objects.trigger.OwlTrigger;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import javax.swing.JFrame;
import org.newdawn.slick.BasicGame;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.tiled.TiledMap;

public class MapRenderer
extends BasicGame {
    TiledMap map;
    int collisionLayer;
    int objectLayer;
    boolean displayCollision = false;
    boolean displayTrigger = true;
    private float zoom = 1.0f;
    private int origX;
    private int origY = 0;
    private Rectangle viewPort = new Rectangle(0.0f, 0.0f, 1280.0f, 720.0f);
    Hero h;
    MouseAdapter mouseAdapter;
    int lastButton = -1;
    LinkedList<IGameEntity> entities = new LinkedList();
    private static JFrame emptyComponent = new JFrame();

    public float getZoom() {
        return this.zoom;
    }

    public int getOrigX() {
        return this.origX;
    }

    public int getOrigY() {
        return this.origY;
    }

    public void increaseZoom() {
        if (this.zoom < 1.0f) {
            this.zoom += 0.1f;
        }
    }

    public void decreaseZoom() {
        if (this.zoom > 0.3f) {
            this.zoom -= 0.1f;
        }
    }

    public Rectangle getViewPort() {
        return this.viewPort;
    }

    public void setViewPort(Rectangle viewPort) {
        this.viewPort = viewPort;
    }

    public MapRenderer(String title) {
        super(title);
    }

    public void setHeroStart(Point pos) {
        this.h.setPosition(new Point2D.Float(pos.x * 64 + 32, pos.y * 64 + 32));
    }

    public void setDisplayTrigger(boolean displayTrigger) {
        this.displayTrigger = displayTrigger;
    }

    public void setMap(TiledMap map) {
        this.entities = new LinkedList();
        this.map = map;
    }

    public LinkedList<IGameEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(LinkedList<IGameEntity> entities) {
        this.entities = entities;
        try {
            for (IGameEntity e : entities) {
                e.init(null, null);
            }
        }
        catch (SlickException e1) {
            e1.printStackTrace();
        }
        this.entities.addLast(this.h);
    }

    private Shape getScaledViewport() {
        Rectangle clone = new Rectangle(this.viewPort.getX(), this.viewPort.getY(), this.viewPort.getWidth(), this.viewPort.getHeight());
        clone.setWidth(this.viewPort.getWidth() / this.zoom);
        clone.setHeight(this.viewPort.getHeight() / this.zoom);
        return clone;
    }

    @Override
    public void render(GameContainer arg0, Graphics g) throws SlickException {
        g.scale(this.zoom, this.zoom);
        Shape viewPort = this.getScaledViewport();
        if (this.map != null) {
            float x = viewPort.getX();
            float y = viewPort.getY();
            int i = 0;
            while (i < this.objectLayer) {
                if (this.displayCollision || i != this.collisionLayer) {
                    this.map.render((int)(-x % 64.0f), (int)(-y % 64.0f), (int)x / 64, (int)y / 64, (int)viewPort.getWidth() / 64 + 2, (int)viewPort.getHeight() / 64 + 2, i, false);
                }
                ++i;
            }
            i = 0;
            while (i < this.entities.size()) {
                IGameEntity e = this.entities.get(i);
                if (e instanceof Trigger && !(e instanceof DoorTrigger)) {
                    g.setColor(Color.blue);
                    g.setLineWidth(3.0f);
                    g.draw(((Trigger)e).getNormalCollisionShape().transform(Transform.createTranslateTransform(-x, -y)));
                    if (e instanceof OwlTrigger) {
                        OwlTrigger o = (OwlTrigger)e;
                        OwlTrigger.owl.draw((float)(o.getOwlX() * 64 + 32 - OwlTrigger.owl.getWidth() / 2) - x, (float)(o.getOwlY() * 64 + 32) - y - (float)OwlTrigger.owl.getHeight());
                    }
                    g.setColor(Color.white);
                    g.drawString(e.getClass().getSimpleName(), e.getPosition().x - x - (float)(g.getFont().getWidth(e.getClass().getSimpleName()) / 2), e.getPosition().y - y - (float)(g.getFont().getHeight(e.getClass().getSimpleName()) / 2));
                } else {
                    e.draw(x, y);
                    if (e instanceof BigGuard) {
                        g.setColor(Color.blue);
                        g.setLineWidth(3.0f);
                        g.draw(((BigGuard)e).getNormalizedBossArea().transform(Transform.createTranslateTransform(-x, -y)));
                    }
                }
                ++i;
            }
            i = this.objectLayer;
            while (i < this.map.getLayerCount()) {
                if (this.displayCollision || i != this.collisionLayer) {
                    this.map.render((int)(-x % 64.0f), (int)(-y % 64.0f), (int)viewPort.getX() / 64, (int)viewPort.getY() / 64, (int)viewPort.getWidth() / 64 + 2, (int)viewPort.getHeight() / 64 + 2, i, false);
                }
                ++i;
            }
            g.setColor(Color.gray);
            g.drawRect(0.0f, 0.0f, this.viewPort.getWidth(), this.viewPort.getHeight());
        }
        g.setColor(Color.black);
        g.setLineWidth(1.0f);
        int x = 0;
        while ((float)x < viewPort.getWidth() + 65.0f) {
            g.drawLine((float)x - viewPort.getX() % 64.0f, 0.0f, (float)x - viewPort.getX() % 64.0f, viewPort.getHeight());
            x += 64;
        }
        int y = 0;
        while ((float)y < viewPort.getHeight() + 65.0f) {
            g.drawLine(0.0f, (float)y - viewPort.getY() % 64.0f, viewPort.getWidth(), (float)y - viewPort.getY() % 64.0f);
            y += 64;
        }
    }

    @Override
    public void init(GameContainer arg0) throws SlickException {
        this.h = new Hero();
        this.h.init(null, null);
        this.h.setDirection(Direction.Down);
        this.entities.add(this.h);
    }

    @Override
    public void update(GameContainer arg0, int delta) throws SlickException {
    }

    public void addMouseListener(MouseAdapter mouseAdapter) {
        this.mouseAdapter = mouseAdapter;
    }

    @Override
    public void mouseClicked(int button, int x, int y, int clickCount) {
        x = (int)((float)x / this.zoom);
        y = (int)((float)y / this.zoom);
        this.mouseAdapter.mouseClicked(new MouseEvent(emptyComponent, 1, 0L, -1, (int)((float)x + this.viewPort.getX()), (int)((float)y + this.viewPort.getY()), clickCount, false, button));
    }

    @Override
    public void mousePressed(int button, int x, int y) {
        this.origX = x;
        this.origY = y;
        x = (int)((float)x / this.zoom);
        y = (int)((float)y / this.zoom);
        this.mouseAdapter.mousePressed(new MouseEvent(emptyComponent, 1, 0L, -1, (int)((float)x + this.viewPort.getX()), (int)((float)y + this.viewPort.getY()), 0, false, button));
        this.lastButton = button;
    }

    @Override
    public void mouseReleased(int button, int x, int y) {
        this.origX = x;
        this.origY = y;
        x = (int)((float)x / this.zoom);
        y = (int)((float)y / this.zoom);
        this.mouseAdapter.mouseReleased(new MouseEvent(emptyComponent, 1, 0L, -1, (int)((float)x + this.viewPort.getX()), (int)((float)y + this.viewPort.getY()), 0, false, button));
    }

    @Override
    public void mouseDragged(int oldx, int oldy, int newx, int newy) {
        this.origX = newx;
        this.origY = newy;
        newx = (int)((float)newx / this.zoom);
        newy = (int)((float)newy / this.zoom);
        this.mouseAdapter.mouseDragged(new MouseEvent(emptyComponent, 1, 0L, -1, (int)((float)newx + this.viewPort.getX()), (int)((float)newy + this.viewPort.getY()), 0, false, this.lastButton));
    }

    @Override
    public void mouseMoved(int oldx, int oldy, int newx, int newy) {
        this.origX = newx;
        this.origY = newy;
        newx = (int)((float)newx / this.zoom);
        newy = (int)((float)newy / this.zoom);
        this.mouseAdapter.mouseMoved(new MouseEvent(emptyComponent, 1, 0L, -1, (int)((float)newx + this.viewPort.getX()), (int)((float)newy + this.viewPort.getY()), 0, false, this.lastButton));
    }

    @Override
    public void mouseWheelMoved(int change) {
        this.mouseAdapter.mouseWheelMoved(new MouseWheelEvent((Component)emptyComponent, 1, 0L, 0, 0, 0, 0, false, 0, change, 0));
    }

    public void setDisplayCollision(boolean displayCollision) {
        this.displayCollision = displayCollision;
    }
}

