/*
 * Decompiled with CFR 0.152.
 */
package game.states;

import game.states.LoadingScreen;
import game.states.ui.SlickButton;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class MainMenu
extends BasicGameState {
    Image background;
    Image credits;
    Image credits1;
    Image credits2;
    SlickButton startButton;
    SlickButton creditButton;
    SlickButton quitButton;
    boolean start = false;
    boolean gameRunning = false;
    boolean displayCredits = false;
    boolean displayGameOver = false;
    int creditPage = 1;
    private Music bgm;
    private int maxBlack = 500;
    private float currentBlack = 0.0f;

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.background = new Image("data/Menu/MainMenu.png");
        this.credits = new Image("data/Menu/CreditsBG.png");
        this.credits1 = new Image("data/Menu/Credits1.png");
        this.credits2 = new Image("data/Menu/Credits2.png");
        this.bgm = new Music("data/sound/music/titleMusic.ogg", true);
        this.startButton = new SlickButton(new Image("data/Menu/Start.png"), new Image("data/Menu/StartSEL.png"));
        this.creditButton = new SlickButton(new Image("data/Menu/Credits.png"), new Image("data/Menu/CreditsSEL.png"));
        this.quitButton = new SlickButton(new Image("data/Menu/Quit.png"), new Image("data/Menu/QuitSEL.png"));
        this.startButton.setPosition(425.0f, 340.0f);
        this.creditButton.setPosition(425.0f, 410.0f);
        this.quitButton.setPosition(425.0f, 480.0f);
    }

    @Override
    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        if (!this.displayCredits) {
            this.background.draw();
            this.startButton.draw();
            this.creditButton.draw();
            this.quitButton.draw();
            if (this.currentBlack > 0.0f) {
                float b = this.currentBlack / (float)this.maxBlack;
                g.setColor(new Color(0.0f, 0.0f, 0.0f, b));
                g.fillRect(0.0f, 0.0f, 1280.0f, 720.0f);
            }
        } else {
            this.credits.draw();
            if (this.creditPage == 1) {
                this.credits1.draw(640 - this.credits1.getWidth() / 2, 220.0f);
            } else {
                this.credits2.draw(640 - this.credits2.getWidth() / 2, 220.0f);
            }
        }
    }

    @Override
    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
        this.currentBlack = 0.0f;
        this.start = false;
        this.bgm.loop();
        this.bgm.setVolume(0.0f);
        this.bgm.fade(500, 1.0f, false);
    }

    @Override
    public void leave(GameContainer container, StateBasedGame game) throws SlickException {
        super.leave(container, game);
        this.bgm.fade(500, 0.0f, true);
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        this.startButton.update(container, game, delta);
        this.creditButton.update(container, game, delta);
        this.quitButton.update(container, game, delta);
        if (this.start) {
            if (this.currentBlack >= (float)this.maxBlack) {
                if (!this.gameRunning) {
                    ((LoadingScreen)game.getState(2)).setMapLocation("data/world.dkm");
                    this.gameRunning = true;
                    game.enterState(2);
                } else {
                    game.enterState(1);
                }
            } else {
                this.currentBlack += (float)delta;
            }
        }
    }

    @Override
    public void mouseClicked(int button, int x, int y, int clickCount) {
        if (this.displayCredits) {
            ++this.creditPage;
            if (this.creditPage == 3) {
                this.creditPage = 1;
                this.displayCredits = false;
            }
            return;
        }
        System.out.println("MouseClicked!");
        if (this.startButton.contains(x, y)) {
            this.start = true;
        } else if (this.creditButton.contains(x, y)) {
            this.displayCredits = true;
        } else if (this.quitButton.contains(x, y)) {
            System.exit(0);
        }
    }

    @Override
    public int getID() {
        return 0;
    }
}

