/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects.usable;

import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.objects.Usable;
import game.core.mechanics.objects.usable.Heart;
import game.core.mechanics.objects.usable.Key;
import game.core.mechanics.objects.usable.Potion;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.state.StateBasedGame;

public class Chest
extends Usable {
    private static final int CHEST_OPENSPEED = 30;
    private Item item;
    private Image obj;
    private int displayObj = 0;
    private float floatUp = 0.0f;

    public Chest(Point2D.Float position, Item item) {
        super(position);
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    @Override
    public void useObject(Hero h) throws SlickException {
        if (this.item == null) {
            return;
        }
        this.soundEffect.play();
        switch (this.item) {
            case Key: {
                h.getInventory().addKey();
                Key k = new Key(null);
                k.init(null, null);
                this.obj = k.getObjectImage();
                break;
            }
            case Heart: {
                h.increaseHP(1);
                Heart he = new Heart(null);
                he.init(null, null);
                this.obj = he.getObjectImage();
                break;
            }
            case Potion: {
                h.getInventory().addPotion();
                Potion p = new Potion(null);
                p.init(null, null);
                this.obj = p.getObjectImage();
            }
        }
        this.displayObj = 400;
        this.item = null;
        this.currentState = Usable.State.Used;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        Image tmp = new Image("data/object/chest.png");
        SpriteSheet s = new SpriteSheet(tmp, tmp.getWidth() / 3, tmp.getHeight());
        this.objectImage = s.getSprite(0, 0);
        this.animationUsable = new Animation(s, 30);
        super.init(container, game);
        this.collision = new Rectangle(31.0f, 46.0f, 69.0f, 49.0f);
        this.soundEffect = new Sound("data/sound/items/chest.ogg");
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        return this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape());
    }

    @Override
    public Shape getNormalCollisionShape() {
        return this.collision.transform(Transform.createTranslateTransform(this.position.x - this.getCollisionShape().getCenterX(), this.position.y - this.getCollisionShape().getCenterY()));
    }

    @Override
    public void draw(float x, float y) {
        super.draw(x, y);
        if (this.displayObj > 0) {
            x = this.position.x - x - (float)(this.obj.getWidth() / 2);
            y = this.position.y - y - (float)this.obj.getHeight();
            this.obj.draw(x, y - this.floatUp);
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (this.displayObj > 0) {
            this.displayObj -= delta;
            this.floatUp += (float)delta * 0.05f;
        }
    }

    public void setItem(Item i) {
        this.item = i;
    }

    public static enum Item {
        Key,
        Heart,
        Potion;

    }
}

