/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects.trigger;

import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.objects.Trigger;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;

public class MessageTrigger
extends Trigger {
    private String message = "";
    private boolean active = false;
    private boolean displayed = false;

    public MessageTrigger(Point2D.Float position) {
        super(position, true);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        super.update(container, game, delta);
        if (this.active && !this.displayed && game != null) {
            this.displayed = true;
            ((GamePlay)game.getState(1)).displayMessage(this.message, 10000);
        }
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        if (this.displayed) {
            return false;
        }
        return this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape());
    }

    @Override
    public boolean activate(Hero h) {
        if (!this.active) {
            this.active = true;
            return true;
        }
        return false;
    }
}

