/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects.trigger;

import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.objects.Trigger;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.state.StateBasedGame;

public class Checkpoint
extends Trigger {
    private boolean checkpointUsed = false;

    public Checkpoint(Point2D.Float position) {
        super(position, true);
        this.collision = new Rectangle(0.0f, 0.0f, 64.0f, 64.0f);
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        return this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape());
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        super.update(container, game, delta);
        if (this.currentState == Trigger.State.Active && !this.checkpointUsed) {
            this.checkpointUsed = true;
            ((GamePlay)game.getState(1)).setCheckpoint();
        }
    }

    @Override
    public boolean activate(Hero h) {
        if (!this.checkpointUsed) {
            this.currentState = Trigger.State.Active;
            return true;
        }
        return false;
    }
}

