/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects;

import game.core.mechanics.Direction;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.objects.GameObject;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.StateBasedGame;

public class Moveable
extends GameObject {
    MoveableType type;
    Direction dir;
    private int maxMove = 2;
    private static final float moveSpeed = 0.15f;
    private boolean playedOnce = false;
    private int currentMove;
    private State currentState = State.Normal;
    private float currentMoveDistance = 0.0f;
    private long lastMillis = 0L;
    private int moveMillis = 0;
    private static int MOVE_MILLIS_THRESHOLD = 500;
    private Point2D.Float newPos = null;

    public void setMaxMove(int maxMove) {
        this.maxMove = maxMove;
    }

    public int getMaxMove() {
        return this.maxMove;
    }

    public MoveableType getType() {
        return this.type;
    }

    public void Move(Direction dir) {
        if (this.currentMove == this.maxMove || this.currentState == State.Moving) {
            return;
        }
        long millis = System.currentTimeMillis();
        this.moveMillis = millis - this.lastMillis > 35L ? 0 : (int)((long)this.moveMillis + (millis - this.lastMillis));
        this.lastMillis = millis;
        if (this.moveMillis < MOVE_MILLIS_THRESHOLD) {
            return;
        }
        this.moveMillis = 0;
        this.dir = dir;
        switch (dir) {
            case Up: {
                this.newPos = new Point2D.Float(this.position.x, this.position.y - 64.0f);
                break;
            }
            case Down: {
                this.newPos = new Point2D.Float(this.position.x, this.position.y + 64.0f);
                break;
            }
            case Left: {
                this.newPos = new Point2D.Float(this.position.x - 64.0f, this.position.y);
                break;
            }
            case Right: {
                this.newPos = new Point2D.Float(this.position.x + 64.0f, this.position.y);
            }
        }
        this.currentState = State.Moving;
        this.currentMoveDistance = 0.0f;
        ++this.currentMove;
    }

    public Moveable(Point2D.Float position, MoveableType type, int maxMove) {
        super(position);
        this.type = type;
        this.maxMove = maxMove;
    }

    @Override
    public Shape getNormalCollisionShape() {
        return this.collision.transform(Transform.createTranslateTransform(this.position.x - this.getCollisionShape().getCenterX(), this.position.y - this.getCollisionShape().getCenterY()));
    }

    @Override
    public Shape getCollisionShape() {
        return this.collision;
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        return this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape());
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        Image img = null;
        switch (this.type) {
            case Rock: {
                this.soundEffect = new Sound("data/sound/sfx/stone.ogg");
                img = new Image("data/object/rock.png");
            }
        }
        this.objectImage = img.getSubImage(0, 0, 64, 64);
        this.collision = new Rectangle(0.0f, 0.0f, 62.0f, 62.0f);
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        Point2D.Float heroPos = ((GamePlay)game.getState(1)).getHero().getPosition();
        if (Math.abs(this.position.x - heroPos.x) > 896.0f || Math.abs(this.position.y - heroPos.y) > 896.0f) {
            ((GamePlay)game.getState(1)).removeEntity(this);
            this.currentMove = 0;
        }
        switch (this.currentState) {
            case Moving: {
                switch (this.dir) {
                    case Up: {
                        this.position.y -= 0.15f * (float)delta;
                        this.lastMovement.x = 0.0f;
                        this.lastMovement.y = -0.15f * (float)delta;
                        break;
                    }
                    case Down: {
                        this.position.y += 0.15f * (float)delta;
                        this.lastMovement.x = 0.0f;
                        this.lastMovement.y = 0.15f * (float)delta;
                        break;
                    }
                    case Left: {
                        this.position.x -= 0.15f * (float)delta;
                        this.lastMovement.x = -0.15f * (float)delta;
                        this.lastMovement.y = 0.0f;
                        break;
                    }
                    case Right: {
                        this.position.x += 0.15f * (float)delta;
                        this.lastMovement.x = 0.15f * (float)delta;
                        this.lastMovement.y = 0.0f;
                    }
                }
                if (!this.playedOnce) {
                    this.soundEffect.play();
                    this.playedOnce = true;
                }
                this.currentMoveDistance += 0.15f * (float)delta;
                if (!(this.currentMoveDistance >= 64.0f)) break;
                this.currentState = State.Normal;
                this.position = this.newPos;
                this.lastMovement = new Vector2f();
                break;
            }
        }
    }

    @Override
    public void draw(float x, float y) {
        x = this.position.x - x - this.getCollisionShape().getCenterX();
        y = this.position.y - y - this.getCollisionShape().getCenterY();
        this.objectImage.draw(x, y);
    }

    @Override
    public int getCollisionType() {
        return 6;
    }

    public void abortMoving() {
        this.currentState = State.Normal;
        this.newPos = this.position;
        this.lastMovement = new Vector2f();
    }

    public static enum MoveableType {
        Block,
        Rock;

    }

    private static enum State {
        Normal,
        Moving;

    }
}

