/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects;

import game.core.mechanics.IGameEntity;
import java.awt.geom.Point2D;
import org.newdawn.slick.Image;
import org.newdawn.slick.Sound;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Vector2f;

public abstract class GameObject
implements IGameEntity {
    protected Point2D.Float position = new Point2D.Float();
    protected Image objectImage;
    protected Sound soundEffect;
    protected Shape collision = null;
    protected Vector2f lastMovement = new Vector2f();

    public GameObject(Point2D.Float position) {
        this.position = position;
    }

    @Override
    public Vector2f getLastMovement() {
        return this.lastMovement;
    }

    @Override
    public int getCollisionType() {
        return 3;
    }

    @Override
    public void setPosition(Point2D.Float position) {
        this.position = position;
    }

    @Override
    public int compareTo(IGameEntity o) {
        if (this.position.y < o.getPosition().y) {
            return -1;
        }
        if (this.position.y > o.getPosition().y) {
            return 1;
        }
        return 0;
    }

    @Override
    public Point2D.Float getPosition() {
        return this.position;
    }
}

