/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.objects;

import game.core.Constants;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.objects.GameObject;
import game.core.mechanics.objects.usable.Heart;
import game.core.mechanics.objects.usable.Potion;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.StateBasedGame;

public class Destructible
extends GameObject {
    private State currentState = State.Normal;
    DestructibleType type;
    Animation destroyAnimation;
    boolean playedOnce = false;
    private boolean itemDropped = false;

    public Destructible(Point2D.Float position, DestructibleType type) {
        super(position);
        this.type = type;
    }

    @Override
    public Vector2f getLastMovement() {
        return new Vector2f();
    }

    public DestructibleType getType() {
        return this.type;
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        Image img = null;
        switch (this.type) {
            case Vase: {
                img = new Image("data/object/vase.png");
                this.soundEffect = new Sound("data/sound/items/vase.ogg");
                break;
            }
            case Shrubbery: {
                img = new Image("data/object/shrubbery.png");
                this.soundEffect = new Sound("data/sound/items/rustle.ogg");
                break;
            }
            case Mushroom: {
                img = new Image("data/object/mushroom.png");
                this.soundEffect = new Sound("data/sound/items/shroom.ogg");
            }
        }
        this.objectImage = img.getSubImage(0, 0, 64, 64);
        SpriteSheet tmp = new SpriteSheet(img.getSubImage(64, 0, img.getWidth() - 64, img.getHeight()), 64, 64);
        this.destroyAnimation = new Animation(tmp, 80);
        this.collision = new Rectangle(0.0f, 0.0f, 64.0f, 64.0f);
        this.destroyAnimation.setLooping(false);
    }

    public void destroy() {
        this.currentState = State.Destroyed;
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        Point2D.Float heroPos = ((GamePlay)game.getState(1)).getHero().getPosition();
        if (Math.abs(this.position.x - heroPos.x) > 896.0f || Math.abs(this.position.y - heroPos.y) > 896.0f) {
            ((GamePlay)game.getState(1)).removeEntity(this);
        }
        if (this.currentState == State.Destroyed && !this.destroyAnimation.isStopped() && !this.playedOnce) {
            this.soundEffect.play();
            this.playedOnce = true;
        }
        if (this.currentState == State.Destroyed && this.destroyAnimation.isStopped() && !this.itemDropped) {
            GamePlay g = (GamePlay)game.getState(1);
            if (Math.random() <= 0.03) {
                g.addEntity(new Potion(null), (int)this.position.x / 64, (int)this.position.y / 64, container, game);
            } else if (Math.random() <= 0.45) {
                g.addEntity(new Heart(null), (int)this.position.x / 64, (int)this.position.y / 64, container, game);
            }
            this.itemDropped = true;
        }
    }

    @Override
    public void draw(float x, float y) {
        x = this.position.x - x - this.getCollisionShape().getCenterX();
        y = this.position.y - y - this.getCollisionShape().getCenterY();
        switch (this.currentState) {
            case Normal: {
                this.objectImage.draw(x, y);
                break;
            }
            case Destroyed: {
                this.destroyAnimation.draw(x, y);
            }
        }
    }

    @Override
    public Shape getNormalCollisionShape() {
        if (this.currentState == State.Destroyed) {
            return Constants.EMPTY_COLLISION;
        }
        return this.collision.transform(Transform.createTranslateTransform(this.position.x - this.getCollisionShape().getCenterX(), this.position.y - this.getCollisionShape().getCenterY()));
    }

    @Override
    public Shape getCollisionShape() {
        return this.collision;
    }

    @Override
    public int getCollisionType() {
        return 5;
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        if (this.currentState == State.Destroyed) {
            return false;
        }
        return this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape());
    }

    public static enum DestructibleType {
        Vase,
        Shrubbery,
        Mushroom;

    }

    private static enum State {
        Normal,
        Destroyed;

    }
}

