/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision.handlers;

import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.CollisionManager;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.collision.ICollisionHandler;
import game.core.mechanics.collision.WeaponCollisionData;

public class HandlerWeaponHero
implements ICollisionHandler {
    @Override
    public int getColliderType() {
        return 4;
    }

    @Override
    public int[] getCollidesWithTypes() {
        return new int[]{1};
    }

    @Override
    public void performCollision(ICollidableObject collidable1, ICollidableObject collidable2, CollisionManager manager) {
        WeaponCollisionData w;
        Hero h;
        if (!collidable1.isCollidingWith(collidable2)) {
            return;
        }
        if (collidable1 instanceof Hero) {
            h = (Hero)collidable1;
            w = (WeaponCollisionData)collidable2;
        } else {
            h = (Hero)collidable2;
            w = (WeaponCollisionData)collidable1;
        }
        if (w.getAttacker() == h || !h.isHitable()) {
            return;
        }
        h.decreaseHP(w.getWeaponDamage());
        float distX = h.getPosition().x - w.getAttackerPosition().x;
        float distY = h.getPosition().y - w.getAttackerPosition().y;
        if (Math.abs(distX) < 10.0f) {
            h.pushTo(0.0f, Math.copySign(150.0f, distY));
        } else if (Math.abs(distY) < 10.0f) {
            h.pushTo(Math.copySign(150.0f, distX), 0.0f);
        } else {
            h.pushTo(Math.copySign(115.5f, distX), Math.copySign(115.5f, distY));
        }
    }
}

