/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision.handlers;

import game.core.mechanics.Direction;
import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.CollisionManager;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.collision.ICollisionHandler;
import game.core.mechanics.collision.handlers.CollisionHelper;
import game.core.mechanics.objects.Moveable;

public class HandlerMoveableHero
implements ICollisionHandler {
    @Override
    public int getColliderType() {
        return 6;
    }

    @Override
    public int[] getCollidesWithTypes() {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 2;
        return nArray;
    }

    @Override
    public void performCollision(ICollidableObject collidable1, ICollidableObject collidable2, CollisionManager manager) {
        Moveable moveable;
        GameCharacter character;
        if (collidable1 instanceof GameCharacter) {
            character = (GameCharacter)collidable1;
            moveable = (Moveable)collidable2;
        } else {
            character = (GameCharacter)collidable2;
            moveable = (Moveable)collidable1;
        }
        short[] direction = character.getCurrentDirection();
        if (character instanceof Hero) {
            float error = 13.0f;
            if (direction[0] == 0 && direction[1] == 1 && Math.abs(moveable.getPosition().x - character.getPosition().x) < error) {
                moveable.Move(Direction.Down);
            } else if (direction[0] == 1 && direction[1] == 0 && Math.abs(moveable.getPosition().y - character.getPosition().y) < error) {
                moveable.Move(Direction.Right);
            } else if (direction[0] == 0 && direction[1] == -1 && Math.abs(moveable.getPosition().x - character.getPosition().x) < error) {
                moveable.Move(Direction.Up);
            } else if (direction[0] == -1 && direction[1] == 0 && Math.abs(moveable.getPosition().y - character.getPosition().y) < error) {
                moveable.Move(Direction.Left);
            }
        }
        CollisionHelper.simpleObjectCollision(moveable, character, manager);
    }
}

