/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision.handlers;

import game.core.mechanics.IGameEntity;
import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.CollisionManager;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.collision.ICollisionHandler;
import game.core.mechanics.collision.handlers.CollisionHelper;
import game.core.mechanics.objects.Trigger;
import game.core.mechanics.objects.trigger.Checkpoint;

public class HandlerHeroTrigger
implements ICollisionHandler {
    @Override
    public int getColliderType() {
        return 8;
    }

    @Override
    public int[] getCollidesWithTypes() {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 2;
        return nArray;
    }

    @Override
    public void performCollision(ICollidableObject collidable1, ICollidableObject collidable2, CollisionManager manager) {
        Trigger t;
        IGameEntity h;
        if (!collidable1.isCollidingWith(collidable2)) {
            return;
        }
        if (collidable2 instanceof Trigger) {
            h = (IGameEntity)collidable1;
            t = (Trigger)collidable2;
        } else {
            h = (IGameEntity)collidable2;
            t = (Trigger)collidable1;
        }
        if (!(h instanceof Hero) && !(t instanceof Checkpoint) || !t.isAutomatic()) {
            CollisionHelper.simpleObjectCollision(t, h, manager);
        } else if (h instanceof Hero && t.isAutomatic()) {
            t.activate((Hero)h);
        }
    }
}

