/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision.handlers;

import game.core.mechanics.character.Hero;
import game.core.mechanics.collision.CollisionManager;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.collision.ICollisionHandler;
import game.core.mechanics.collision.WeaponCollisionData;
import game.core.mechanics.objects.Destructible;

public class HandlerDestructibleWeapon
implements ICollisionHandler {
    @Override
    public int getColliderType() {
        return 5;
    }

    @Override
    public int[] getCollidesWithTypes() {
        return new int[]{4};
    }

    @Override
    public void performCollision(ICollidableObject collidable1, ICollidableObject collidable2, CollisionManager manager) {
        WeaponCollisionData w;
        Destructible d;
        if (!collidable1.isCollidingWith(collidable2)) {
            return;
        }
        if (collidable1 instanceof WeaponCollisionData) {
            d = (Destructible)collidable2;
            w = (WeaponCollisionData)collidable1;
        } else {
            d = (Destructible)collidable1;
            w = (WeaponCollisionData)collidable2;
        }
        if (w.getAttacker().getClass() != Hero.class) {
            return;
        }
        d.destroy();
    }
}

