/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.collision.handlers;

import game.core.mechanics.IGameEntity;
import game.core.mechanics.collision.CollisionManager;
import java.awt.geom.Point2D;
import org.newdawn.slick.geom.Vector2f;

public class CollisionHelper {
    static void simpleObjectCollision(IGameEntity pusher, IGameEntity mover, CollisionManager manager) {
        if (!pusher.isCollidingWith(mover)) {
            return;
        }
        Vector2f lastMov = mover.getLastMovement();
        Point2D.Float newPos = (Point2D.Float)mover.getPosition().clone();
        Point2D.Float oldPos = (Point2D.Float)newPos.clone();
        boolean colX = false;
        boolean colY = false;
        if (lastMov.getX() != 0.0f) {
            newPos.x -= lastMov.x;
            mover.setPosition(newPos);
            if (!mover.isCollidingWith(pusher) && !manager.isEntityColiding(mover, 0.0f, 0.0f, false)) {
                colX = true;
            }
            newPos.x = oldPos.x;
        }
        if (lastMov.getY() != 0.0f) {
            newPos.y -= lastMov.y;
            mover.setPosition(newPos);
            if (!mover.isCollidingWith(pusher) && !manager.isEntityColiding(mover, 0.0f, 0.0f, false)) {
                colY = true;
            }
            newPos.y = oldPos.y;
        }
        if (colX) {
            newPos.x -= lastMov.x;
        }
        if (colY) {
            newPos.y -= lastMov.y;
        }
        if (!colX && !colY) {
            newPos.x -= lastMov.x;
            newPos.y -= lastMov.y;
        }
        mover.setPosition(newPos);
    }
}

