/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.character;

import game.core.Constants;
import game.core.mechanics.Direction;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.character.Citizen;
import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.character.Inventory;
import game.core.mechanics.collision.HeroTriggerCollision;
import game.core.mechanics.collision.WeaponCollisionData;
import game.core.mechanics.objects.Trigger;
import game.core.mechanics.objects.usable.Chest;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.KeyListener;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.state.StateBasedGame;

public class Hero
extends GameCharacter
implements KeyListener {
    private static final int heroHeight = 122;
    private static final int heroWidth = 62;
    private static final int walkAnimatonSpeed = 85;
    private static final int attackAnimatonSpeed = 60;
    Image weaponImage;
    WeaponCollisionData weapon;
    Shape weaponCollision;
    Sound weaponSound;
    float weaponAngle = 60.0f;
    float weaponSpeed = 0.24f;
    float weaponOffsetX = 20.0f;
    float weaponOffsetY = 15.0f;
    Animation attackUp;
    Animation attackDown;
    Animation attackLeft;
    Animation attackRight;
    Sound drinkSound;
    Sound stepSound;
    Sound moan;
    int aktHP;
    int maxHP;
    Inventory inventar = new Inventory(0, 0, 1);
    Input currentInput;
    State currentState = State.Moving;
    IGameEntity currentTriggerTarget;
    float rotateAngle = 0.0f;
    float startAngle = 0.0f;
    Point2D.Float weaponPos = new Point2D.Float();
    HeroTriggerCollision triggerCollision;
    private boolean allowInput = true;

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        if (container != null) {
            container.getInput().addKeyListener(this);
        }
        this.drinkSound = new Sound("data/sound/sfx/drink.ogg");
        this.stepSound = new Sound("data/sound/sfx/steps.ogg");
        this.sfx = new Sound("data/sound/sfx/sword.ogg");
        Image heroIm = new Image("data/character/main_char.png");
        Image[] anim = new Image[8];
        int i = 0;
        while (i < 8) {
            anim[i] = heroIm.getSubImage(0, i * 122, heroIm.getWidth(), 122);
            ++i;
        }
        SpriteSheet temp = new SpriteSheet(anim[1], 62, 122);
        this.up = new Animation(temp, 85);
        temp = new SpriteSheet(anim[0], 62, 122);
        this.down = new Animation(temp, 85);
        temp = new SpriteSheet(anim[2], 62, 122);
        this.left = new Animation(temp, 85);
        temp = new SpriteSheet(anim[3], 62, 122);
        this.right = new Animation(temp, 85);
        this.up.setPingPong(true);
        this.down.setPingPong(true);
        this.left.setPingPong(true);
        this.right.setPingPong(true);
        temp = new SpriteSheet(anim[4], 62, 122);
        this.attackDown = new Animation(temp, 60);
        temp = new SpriteSheet(anim[5], 62, 122);
        this.attackUp = new Animation(temp, 60);
        temp = new SpriteSheet(anim[6], 62, 122);
        this.attackLeft = new Animation(temp, 60);
        temp = new SpriteSheet(anim[7], 62, 122);
        this.attackRight = new Animation(temp, 60);
        this.attackUp.setLooping(false);
        this.attackDown.setLooping(false);
        this.attackLeft.setLooping(false);
        this.attackRight.setLooping(false);
        this.weaponImage = new Image("data/character/sword.png");
        this.weaponCollision = new Rectangle(0.0f, 0.0f, this.weaponImage.getWidth(), 50.0f);
        this.weapon = new WeaponCollisionData(1, this, Constants.EMPTY_COLLISION);
        this.aktHP = this.maxHP = 10;
        this.speed = 0.3f;
        this.collision = new Rectangle(1.0f, 62.0f, 60.0f, 60.0f);
        this.triggerCollision = new HeroTriggerCollision(this);
        this.moan = new Sound("data/sound/character/heroMoan.ogg");
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if ((this.charState == GameCharacter.CharacterState.Moving || this.charState == GameCharacter.CharacterState.Standing) && this.allowInput) {
            if (container.getInput().isKeyDown(200)) {
                this.startMoving(Direction.Up);
            }
            if (container.getInput().isKeyDown(203)) {
                this.startMoving(Direction.Left);
            }
            if (container.getInput().isKeyDown(205)) {
                this.startMoving(Direction.Right);
            }
            if (container.getInput().isKeyDown(208)) {
                this.startMoving(Direction.Down);
            }
        }
        if (this.charState == GameCharacter.CharacterState.Moving && !this.stepSound.playing()) {
            this.stepSound.loop();
        } else if (this.charState == GameCharacter.CharacterState.Standing && this.stepSound.playing()) {
            this.stepSound.stop();
        }
        super.update(container, game, delta);
        if (this.charState != GameCharacter.CharacterState.Custom) {
            return;
        }
        switch (this.currentState) {
            case Attacking: {
                if (this.rotateAngle < 0.0f) {
                    this.currentState = State.Moving;
                    this.weapon.setNormalCollisionShape(Constants.EMPTY_COLLISION);
                    this.resetCharacterState();
                    break;
                }
                this.weaponImage.setCenterOfRotation(this.weaponImage.getWidth() / 2, this.weaponImage.getHeight());
                this.weaponImage.rotate(this.weaponSpeed * (float)delta);
                this.rotateAngle -= this.weaponSpeed * (float)delta;
                this.weaponPos.x = this.position.x - (float)(this.weaponImage.getWidth() / 2);
                this.weaponPos.y = this.position.y - (float)this.weaponImage.getHeight() - 40.0f;
                switch (this.direction) {
                    case Up: {
                        this.weaponPos.x += this.weaponOffsetX;
                        this.weaponPos.y += this.weaponOffsetY;
                        break;
                    }
                    case Down: {
                        this.weaponPos.x -= this.weaponOffsetX;
                        this.weaponPos.y += this.weaponOffsetY + 10.0f;
                        break;
                    }
                    case Left: {
                        this.weaponPos.y += this.weaponOffsetY;
                        break;
                    }
                    case Right: {
                        this.weaponPos.y += this.weaponOffsetY;
                    }
                }
                this.weapon.setNormalCollisionShape(this.weaponCollision.transform(Transform.createRotateTransform((float)Math.toRadians(this.weaponImage.getRotation()), this.weaponImage.getWidth() / 2, this.weaponImage.getHeight())).transform(Transform.createTranslateTransform(this.weaponPos.x, this.weaponPos.y)));
                break;
            }
        }
    }

    public void drawStats() {
        this.inventar.draw(this.aktHP, this.maxHP);
    }

    @Override
    public void draw(float x, float y) {
        super.draw(x, y);
        if (this.charState != GameCharacter.CharacterState.Custom) {
            return;
        }
        block0 : switch (this.currentState) {
            case Attacking: {
                switch (this.direction) {
                    case Up: {
                        this.weaponImage.draw(this.weaponPos.x - x, this.weaponPos.y - y);
                        this.attackUp.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                        break block0;
                    }
                    case Down: {
                        this.attackDown.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                        this.weaponImage.draw(this.weaponPos.x - x, this.weaponPos.y - y);
                        break block0;
                    }
                    case Left: {
                        this.weaponImage.draw(this.weaponPos.x - x, this.weaponPos.y - y);
                        this.attackLeft.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                        break block0;
                    }
                    case Right: {
                        this.weaponImage.draw(this.weaponPos.x - x, this.weaponPos.y - y);
                        this.attackRight.draw(this.position.x - x - this.collision.getCenterX(), this.position.y - y - this.collision.getCenterY());
                    }
                }
            }
        }
    }

    @Override
    public void keyPressed(int key, char c) {
        if (key == 1) {
            this.stepSound.stop();
        }
        if (this.currentState == State.Moving && key == 57) {
            if (this.charState == GameCharacter.CharacterState.Hit) {
                return;
            }
            if (this.currentTriggerTarget != null && this.currentTriggerTarget.isCollidingWith(this.triggerCollision)) {
                if (this.currentTriggerTarget instanceof Trigger) {
                    ((Trigger)this.currentTriggerTarget).activate(this);
                    return;
                }
                if (this.currentTriggerTarget instanceof Chest) {
                    try {
                        ((Chest)this.currentTriggerTarget).useObject(this);
                    }
                    catch (SlickException e) {
                        System.err.println("Error while using Chest!");
                    }
                    return;
                }
                if (this.currentTriggerTarget instanceof Citizen) {
                    ((Citizen)this.currentTriggerTarget).startDialog();
                    return;
                }
            }
            switch (this.direction) {
                case Up: {
                    this.startAngle = 0.0f - this.weaponAngle / 2.0f;
                    this.sfx.play();
                    this.attackUp.restart();
                    break;
                }
                case Down: {
                    this.startAngle = 180.0f - this.weaponAngle / 2.0f;
                    this.sfx.play();
                    this.attackDown.restart();
                    break;
                }
                case Left: {
                    this.startAngle = -90.0f - this.weaponAngle / 2.0f;
                    this.sfx.play();
                    this.attackLeft.restart();
                    break;
                }
                case Right: {
                    this.startAngle = 90.0f - this.weaponAngle / 2.0f;
                    this.sfx.play();
                    this.attackRight.restart();
                }
            }
            this.rotateAngle = this.weaponAngle;
            this.currentState = State.Attacking;
            this.charState = GameCharacter.CharacterState.Custom;
            this.weaponImage.setRotation(this.startAngle);
            this.directionModFreeze = this.directionMod;
            this.directionFreeze = this.direction;
        }
        if (key == 45 && this.getInventory().getPotion() != 0) {
            this.drinkSound.play();
            this.aktHP = this.maxHP;
            this.getInventory().removePotion();
        }
    }

    @Override
    public void keyReleased(int key, char c) {
        if (key == 200 || key == 208) {
            this.stopMoving(Direction.Up);
        } else if (key == 205 || key == 203) {
            this.stopMoving(Direction.Left);
        }
    }

    @Override
    public void pushTo(float driftX, float driftY) {
        this.currentState = State.Moving;
        this.weapon.setNormalCollisionShape(Constants.EMPTY_COLLISION);
        super.pushTo(driftX, driftY);
    }

    @Override
    public void setInput(Input input) {
        this.currentInput = input;
    }

    public void setAllowInput(boolean allowInput) {
        this.allowInput = allowInput;
    }

    @Override
    public boolean isAcceptingInput() {
        return this.charState != GameCharacter.CharacterState.Dead && this.allowInput;
    }

    @Override
    public void inputEnded() {
    }

    @Override
    public void inputStarted() {
    }

    public HeroTriggerCollision getTriggerCollision() {
        return this.triggerCollision;
    }

    @Override
    public int getCollisionType() {
        return 1;
    }

    public void setCurrentTriggerTarget(IGameEntity currentTriggerTarget) {
        this.currentTriggerTarget = currentTriggerTarget;
    }

    public void increaseHP(int value) {
        this.aktHP += value;
        if (this.aktHP > this.maxHP) {
            this.aktHP = this.maxHP;
        }
    }

    public void decreaseHP(int i) {
        this.aktHP -= i;
        if (this.aktHP <= 0) {
            this.aktHP = 0;
            this.charState = GameCharacter.CharacterState.Dead;
        } else {
            this.moan.play();
        }
    }

    public boolean isAttacking() {
        return this.currentState == State.Attacking;
    }

    public WeaponCollisionData getWeaponCollision() {
        return this.weapon;
    }

    public int getAktHP() {
        return this.aktHP;
    }

    public Inventory getInventory() {
        return this.inventar;
    }

    public void revive() {
        this.aktHP = this.maxHP;
        this.charState = GameCharacter.CharacterState.Standing;
        this.stopMoving(Direction.Up);
        this.stopMoving(Direction.Left);
    }

    public void stopSound() {
        if (this.stepSound.playing()) {
            this.stepSound.stop();
        }
    }

    private static enum State {
        Moving,
        Attacking;

    }
}

