/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.character;

import game.core.Constants;
import game.core.mechanics.Direction;
import game.core.mechanics.character.Enemy;
import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.collision.WeaponCollisionData;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.state.StateBasedGame;

public class Guard
extends Enemy {
    private static final int GUARD_HEIGHT = 130;
    private static final int GUARD_WIDTH = 75;
    private static final int GUARD_ANIMATIONSPEED_WALK = 180;
    private static final int GUARD_ANIMATIONSPEED_ATTACK = 140;
    Animation upAttack = null;
    Animation downAttack = null;
    Animation leftAttack = null;
    Animation rightAttack = null;
    Image weaponImage;
    Shape weaponCollision;
    WeaponCollisionData weaponCollisionData;
    Sound weaponSound;
    float weaponSpeed = 0.1f;
    float weaponRange;
    float attackDistance = 200.0f;
    float currentWeaponRange = 0.0f;
    State currentState = State.Moving;
    float weaponXOffset;
    float weaponYOffset;
    private int attackTime = 500;

    @Override
    public void draw(float x, float y) {
        super.draw(x, y);
        if (this.charState == GameCharacter.CharacterState.Dead || this.charState != GameCharacter.CharacterState.Custom) {
            return;
        }
        if (this.blinking && this.blink > 100) {
            return;
        }
        x = this.position.x - x;
        y = this.position.y - y;
        if (this.currentState == State.Attacking) {
            switch (this.direction) {
                case Up: {
                    this.weaponImage.draw(x + this.weaponXOffset, y + this.weaponYOffset);
                    this.upAttack.draw(x - this.getCollisionShape().getCenterX(), y - this.getCollisionShape().getCenterY());
                    break;
                }
                case Down: {
                    this.downAttack.draw(x - this.getCollisionShape().getCenterX(), y - this.getCollisionShape().getCenterY());
                    this.weaponImage.draw(x + this.weaponXOffset, y + this.weaponYOffset);
                    break;
                }
                case Left: {
                    this.weaponImage.draw(x + this.weaponXOffset, y + this.weaponYOffset);
                    this.leftAttack.draw(x - this.getCollisionShape().getCenterX(), y - this.getCollisionShape().getCenterY());
                    break;
                }
                case Right: {
                    this.rightAttack.draw(x - this.getCollisionShape().getCenterX(), y - this.getCollisionShape().getCenterY());
                    this.weaponImage.draw(x + this.weaponXOffset, y + this.weaponYOffset);
                }
            }
        }
    }

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.aktHP = this.maxHP = (short)3;
        this.moan = new Sound("data/sound/character/guard.ogg");
        this.weaponImage = new Image("data/character/lance_front.png");
        Image guard = new Image("data/character/guard.png");
        Image[] anim = new Image[8];
        int i = 0;
        while (i < 8) {
            anim[i] = guard.getSubImage(0, i * 130, guard.getWidth(), 130);
            ++i;
        }
        SpriteSheet temp = new SpriteSheet(anim[1], 75, 130);
        this.up = new Animation(temp, 180);
        temp = new SpriteSheet(anim[0], 75, 130);
        this.down = new Animation(temp, 180);
        temp = new SpriteSheet(anim[2], 75, 130);
        this.left = new Animation(temp, 180);
        temp = new SpriteSheet(anim[3], 75, 130);
        this.right = new Animation(temp, 180);
        this.up.setPingPong(true);
        this.down.setPingPong(true);
        this.left.setPingPong(true);
        this.right.setPingPong(true);
        temp = new SpriteSheet(anim[5], 75, 130);
        this.upAttack = new Animation(temp, 140);
        temp = new SpriteSheet(anim[4], 75, 130);
        this.downAttack = new Animation(temp, 140);
        temp = new SpriteSheet(anim[6], 75, 130);
        this.leftAttack = new Animation(temp, 140);
        temp = new SpriteSheet(anim[7], 75, 130);
        this.rightAttack = new Animation(temp, 140);
        this.upAttack.setPingPong(true);
        this.downAttack.setPingPong(true);
        this.leftAttack.setPingPong(true);
        this.rightAttack.setPingPong(true);
        this.speed = 0.25f;
        this.weaponSpeed = 0.08f;
        this.weaponRange = 20.0f;
        this.weaponCollision = new Rectangle(0.0f, 0.0f, this.weaponImage.getWidth(), this.weaponImage.getHeight());
        this.weaponCollisionData = new WeaponCollisionData(1, this, Constants.EMPTY_COLLISION);
        this.collision = new Rectangle(6.5f, 100.0f, 62.0f, 30.0f);
        this.attackDistance = this.weaponImage.getHeight() - 30;
    }

    @Override
    public void pushTo(float driftX, float driftY) {
        this.currentState = State.Moving;
        this.weaponCollisionData.setNormalCollisionShape(Constants.EMPTY_COLLISION);
        super.pushTo(driftX, driftY);
    }

    private void updateWeapon() {
        switch (this.direction) {
            case Up: {
                this.weaponImage.setRotation(0.0f);
                this.weaponXOffset = -(this.weaponImage.getWidth() / 2) + 20;
                this.weaponYOffset = (float)(-this.weaponImage.getHeight()) + this.currentWeaponRange * -1.0f - 10.0f;
                break;
            }
            case Down: {
                this.weaponImage.setRotation(-180.0f);
                this.weaponXOffset = -(this.weaponImage.getWidth() / 2) - 20;
                this.weaponYOffset = (float)(-this.weaponImage.getHeight()) + this.currentWeaponRange - 65.0f;
                break;
            }
            case Left: {
                this.weaponImage.setRotation(-90.0f);
                this.weaponXOffset = this.currentWeaponRange * -1.0f;
                this.weaponYOffset = -this.weaponImage.getHeight() - 30;
                break;
            }
            case Right: {
                this.weaponImage.setRotation(90.0f);
                this.weaponXOffset = (float)(-this.weaponImage.getWidth()) + this.currentWeaponRange;
                this.weaponYOffset = -this.weaponImage.getHeight() - 30;
            }
        }
        this.weaponImage.setCenterOfRotation(this.weaponCollision.getCenterX(), this.weaponCollision.getMaxY());
        Shape result = this.weaponCollision.transform(Transform.createRotateTransform((float)Math.toRadians(this.weaponImage.getRotation()), this.weaponCollision.getCenterX(), this.weaponCollision.getMaxY()));
        result = result.transform(Transform.createTranslateTransform(this.position.x + this.weaponXOffset, this.position.y + this.weaponYOffset));
        this.weaponCollisionData.setNormalCollisionShape(result);
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        float posError;
        super.update(container, game, delta);
        if (this.charState == GameCharacter.CharacterState.Dead) {
            return;
        }
        Point2D.Float heroPos = ((GamePlay)game.getState(1)).getHero().getPosition();
        float distX = Math.abs(this.position.x - heroPos.x);
        float distY = Math.abs(this.position.y - heroPos.y);
        if (this.charState == GameCharacter.CharacterState.Moving && (distX < (posError = 30.0f) && distY <= this.attackDistance || distY < posError && distX <= this.attackDistance)) {
            this.currentState = State.Attacking;
            this.charState = GameCharacter.CharacterState.Custom;
        }
        if (this.charState != GameCharacter.CharacterState.Custom) {
            return;
        }
        if (this.currentState == State.Attacking) {
            float k = (this.position.y - heroPos.y) / (this.position.x - heroPos.x + 0.001f);
            this.direction = this.position.x - heroPos.x + 0.001f < 0.0f ? (k > 1.0f ? Direction.Down : (k < -1.0f ? Direction.Up : Direction.Right)) : (k > 1.0f ? Direction.Up : (k < -1.0f ? Direction.Down : Direction.Left));
            if (this.currentWeaponRange > this.weaponRange) {
                this.weaponSpeed *= -1.0f;
                this.currentWeaponRange = this.weaponRange;
            } else if (this.currentWeaponRange < 0.0f) {
                this.weaponSpeed *= -1.0f;
                this.currentWeaponRange = 0.0f;
            }
            this.currentWeaponRange += this.weaponSpeed * (float)delta;
            this.updateWeapon();
            if (this.attackTime > 0) {
                this.attackTime -= delta;
            }
            if ((distX > this.attackDistance || distY > this.attackDistance) && this.attackTime < 0) {
                this.attackTime = 500;
                this.currentState = State.Moving;
                this.currentWeaponRange = 0.0f;
                this.weaponCollisionData.setNormalCollisionShape(Constants.EMPTY_COLLISION);
                this.resetCharacterState();
            }
        }
    }

    @Override
    public WeaponCollisionData getWeaponCollision() {
        return this.weaponCollisionData;
    }

    private static enum State {
        Moving,
        Attacking;

    }
}

