/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.character;

import game.core.Constants;
import game.core.mechanics.Direction;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.character.BigGuard;
import game.core.mechanics.collision.ICollidableObject;
import game.core.mechanics.pathfinding.Path;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.util.pathfinding.Mover;
import org.newdawn.slick.util.pathfinding.Path;

public abstract class GameCharacter
implements IGameEntity,
Mover {
    Animation up = null;
    Animation down = null;
    Animation left = null;
    Animation right = null;
    Sound sfx = null;
    Point2D.Float position = new Point2D.Float();
    float speed;
    short[] directionMod = new short[2];
    Direction direction = Direction.Up;
    CharacterState charState = CharacterState.Standing;
    short[] directionModFreeze = new short[2];
    Direction directionFreeze = Direction.Up;
    short[] hitMod = new short[2];
    float hitCurrentDistance = 0.0f;
    float hitDistance = 0.0f;
    float hitJumpOffset = 0.0f;
    protected int blink = 200;
    private static final int MAX_BLINK_DURATION = 1000;
    private int blinkDuration = 0;
    protected boolean blinking = false;
    protected Path path = new Path();
    protected int currentStep = 0;
    Rectangle collision = null;
    Vector2f lastMovement = new Vector2f();

    public Direction getDirection() {
        return this.direction;
    }

    public CharacterState getCharState() {
        return this.charState;
    }

    public void setCharState(CharacterState charState) {
        this.charState = charState;
    }

    public boolean isHitable() {
        return this.charState != CharacterState.Hit && this.charState != CharacterState.Dead && !this.blinking && this.blinkDuration <= 0;
    }

    @Override
    public void draw(float x, float y) {
        if (this.charState == CharacterState.Custom) {
            return;
        }
        x = this.position.x - x - this.getCollisionShape().getCenterX();
        y = this.position.y - y - this.getCollisionShape().getCenterY() - this.hitJumpOffset;
        if (this.blinking && this.blink > 100) {
            return;
        }
        switch (this.direction) {
            case Up: {
                if (this.charState == CharacterState.Moving) {
                    this.up.draw(x, y);
                    break;
                }
                this.up.getImage(2).draw(x, y);
                break;
            }
            case Down: {
                if (this.charState == CharacterState.Moving) {
                    this.down.draw(x, y);
                    break;
                }
                this.down.getImage(2).draw(x, y);
                break;
            }
            case Left: {
                if (this.charState == CharacterState.Moving) {
                    this.left.draw(x, y);
                    break;
                }
                this.left.getImage(2).draw(x, y);
                break;
            }
            case Right: {
                if (this.charState == CharacterState.Moving) {
                    this.right.draw(x, y);
                    break;
                }
                this.right.getImage(2).draw(x, y);
            }
        }
    }

    public void resetCharacterState() {
        this.charState = this.directionMod[0] == 0 && this.directionMod[1] == 0 ? CharacterState.Standing : CharacterState.Moving;
        this.direction = this.directionFreeze;
        this.directionMod = this.directionModFreeze;
    }

    @Override
    public int compareTo(IGameEntity o) {
        if (this.position.y < o.getPosition().y) {
            return -1;
        }
        if (this.position.y > o.getPosition().y) {
            return 1;
        }
        return 0;
    }

    @Override
    public Vector2f getLastMovement() {
        return this.lastMovement;
    }

    public void setDirection(Direction dir) {
        this.direction = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMoving(int delta) {
        if (this.path != null && this.currentStep < this.path.getLength()) {
            Path.Step current;
            this.stopMoving(Direction.Up);
            this.stopMoving(Direction.Left);
            Path path = this.path;
            synchronized (path) {
                current = this.path.getStep(this.currentStep);
            }
            int stepX = current.getX();
            int stepY = current.getY();
            float moveError = 2.0f;
            if (Math.abs((float)stepX - this.position.x) <= moveError && Math.abs((float)stepY - this.position.y) <= moveError && this.currentStep < this.path.getLength() - 1) {
                this.position.x = stepX;
                this.position.y = stepY;
                ++this.currentStep;
                Path path2 = this.path;
                synchronized (path2) {
                    current = this.path.getStep(this.currentStep);
                }
                stepX = current.getX();
                stepY = current.getY();
            }
            if (this.position.x > (float)stepX + moveError) {
                this.startMoving(Direction.Left);
            } else if (this.position.x < (float)stepX - moveError) {
                this.startMoving(Direction.Right);
            }
            if (this.position.y > (float)stepY + moveError) {
                this.startMoving(Direction.Up);
            } else if (this.position.y < (float)stepY - moveError) {
                this.startMoving(Direction.Down);
            }
        }
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        float curSpeed;
        short[] mod;
        if (this.blinking) {
            this.blink -= delta;
            this.blinkDuration -= delta;
            if (this.blink <= 0) {
                this.blink = 200;
            }
            if (this.blinkDuration <= 0) {
                this.blinking = false;
            }
        }
        if (this.charState == CharacterState.Dead) {
            this.lastMovement = new Vector2f();
        }
        if (this.charState == CharacterState.Custom || this.charState == CharacterState.Standing || this.charState == CharacterState.Dead) {
            return;
        }
        Point2D.Float heroPos = ((GamePlay)game.getState(1)).getHero().getPosition();
        if (!(this instanceof BigGuard) && (Math.abs(this.position.x - heroPos.x) > 896.0f || Math.abs(this.position.y - heroPos.y) > 896.0f)) {
            ((GamePlay)game.getState(1)).removeEntity(this);
        }
        float factor = 1.0f;
        switch (this.charState) {
            case Moving: {
                this.processMoving(delta);
                mod = this.directionMod;
                curSpeed = this.speed;
                break;
            }
            case Hit: {
                mod = this.hitMod;
                curSpeed = 0.6f;
                this.hitCurrentDistance -= curSpeed * (float)delta;
                this.hitJumpOffset = (float)(Math.sin(Math.PI * (double)(this.hitCurrentDistance / this.hitDistance)) * 20.0);
                break;
            }
            default: {
                return;
            }
        }
        if (mod[0] != 0 && mod[1] != 0) {
            factor = 0.70711f;
        }
        this.position.x += (float)mod[0] * curSpeed * factor * (float)delta;
        this.position.y += (float)mod[1] * curSpeed * factor * (float)delta;
        this.lastMovement.x = (float)mod[0] * curSpeed * factor * (float)delta;
        this.lastMovement.y = (float)mod[1] * curSpeed * factor * (float)delta;
        if (this.hitCurrentDistance < 0.0f && this.charState == CharacterState.Hit && !this.blinking) {
            this.hitJumpOffset = 0.0f;
            this.blinkDuration = 1000;
            this.blink = 200;
            this.resetCharacterState();
            this.blinking = true;
        }
    }

    public void pushTo(float driftX, float driftY) {
        if (this.charState == CharacterState.Hit || this.charState == CharacterState.Dead) {
            return;
        }
        int driftRange = 40;
        this.hitMod[0] = driftX < (float)(driftRange * -1) ? -1 : (driftX > (float)driftRange ? 1 : 0);
        this.hitMod[1] = driftY < (float)(driftRange * -1) ? -1 : (driftY > (float)driftRange ? 1 : 0);
        float minDrift = Math.min(driftX, driftY);
        this.direction = minDrift == driftX && driftY < 0.0f ? Direction.Down : (minDrift == driftX ? Direction.Up : (driftX < 0.0f ? Direction.Right : Direction.Left));
        this.hitDistance = this.hitCurrentDistance = (float)Math.sqrt(driftY * driftY + driftX * driftX);
        this.directionFreeze = this.direction;
        this.directionModFreeze = this.directionMod;
        this.charState = CharacterState.Hit;
    }

    @Override
    public Point2D.Float getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Point2D.Float position) {
        this.position = position;
    }

    public float getCurrentSpeed() {
        if (this.charState == CharacterState.Hit) {
            return 0.6f;
        }
        return this.speed;
    }

    public short[] getCurrentDirection() {
        if (this.charState == CharacterState.Hit) {
            return this.hitMod;
        }
        return this.directionMod;
    }

    public void startMoving(Direction dir) {
        short[] dm = this.directionMod;
        Direction dire = this.direction;
        if (this.charState == CharacterState.Custom || this.charState == CharacterState.Hit) {
            dm = this.directionModFreeze;
            dire = this.directionFreeze;
        }
        if (dir == Direction.Up) {
            dm[1] = -1;
            if (dm[0] == 0) {
                dire = Direction.Up;
            }
        } else if (dir == Direction.Left) {
            dm[0] = -1;
            if (dm[1] == 0) {
                dire = Direction.Left;
            }
        } else if (dir == Direction.Right) {
            dm[0] = 1;
            if (dm[1] == 0) {
                dire = Direction.Right;
            }
        } else {
            dm[1] = 1;
            if (dm[0] == 0) {
                dire = Direction.Down;
            }
        }
        if (this.charState != CharacterState.Custom && this.charState != CharacterState.Hit) {
            this.charState = CharacterState.Moving;
            this.direction = dire;
            this.directionMod = dm;
        } else {
            this.directionFreeze = dire;
            this.directionModFreeze = dm;
        }
    }

    public void stopMoving(Direction dir) {
        short[] dm = this.directionMod;
        Direction dire = this.direction;
        if (this.charState == CharacterState.Custom || this.charState == CharacterState.Hit) {
            dm = this.directionModFreeze;
            dire = this.directionFreeze;
        }
        if (dir == Direction.Up || dir == Direction.Down) {
            dm[1] = 0;
            if (dm[0] == 1) {
                dire = Direction.Right;
            } else if (dm[0] == -1) {
                dire = Direction.Left;
            } else if (this.charState != CharacterState.Custom && this.charState != CharacterState.Hit) {
                this.charState = CharacterState.Standing;
            }
        } else if (dir == Direction.Left || dir == Direction.Right) {
            dm[0] = 0;
            if (dm[1] == 1) {
                dire = Direction.Down;
            } else if (dm[1] == -1) {
                dire = Direction.Up;
            } else if (this.charState != CharacterState.Custom && this.charState != CharacterState.Hit) {
                this.charState = CharacterState.Standing;
            }
        }
        if (this.charState != CharacterState.Custom && this.charState != CharacterState.Hit) {
            this.direction = dire;
            this.directionMod = dm;
        } else {
            this.directionFreeze = dire;
            this.directionModFreeze = dm;
        }
    }

    @Override
    public Shape getCollisionShape() {
        return this.collision;
    }

    @Override
    public Shape getNormalCollisionShape() {
        if (this.charState == CharacterState.Dead) {
            return Constants.EMPTY_COLLISION;
        }
        return this.collision.transform(Transform.createTranslateTransform(this.position.x - this.getCollisionShape().getCenterX(), this.position.y - this.getCollisionShape().getCenterY()));
    }

    @Override
    public boolean isCollidingWith(ICollidableObject collidable) {
        if (this.charState == CharacterState.Dead || collidable.getNormalCollisionShape() == Constants.EMPTY_COLLISION) {
            return false;
        }
        return this.getNormalCollisionShape().intersects(collidable.getNormalCollisionShape()) || this.getPosition().equals(collidable.getPosition());
    }

    public static enum CharacterState {
        Waiting,
        Alert,
        Moving,
        Standing,
        Hit,
        Dead,
        Custom;

    }
}

