/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.character;

import game.core.mechanics.Direction;
import game.core.mechanics.character.Enemy;
import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.collision.WeaponCollisionData;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.state.StateBasedGame;

public class Dwarf
extends Enemy {
    private static final int dwarfHeight = 110;
    private static final int dwarfWidth = 62;

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.speed = 0.3f;
        this.collision = new Rectangle(0.0f, 80.0f, 62.0f, 30.0f);
        this.aktHP = this.maxHP = 1;
        this.bodyDamage = 2;
        Image dwarf = new Image("data/character/dwarf.png");
        Image[] anim = new Image[4];
        int i = 0;
        while (i < 4) {
            anim[i] = dwarf.getSubImage(0, i * 110, dwarf.getWidth(), 110);
            ++i;
        }
        SpriteSheet temp = new SpriteSheet(anim[1], 62, 110);
        this.up = new Animation(temp, 180);
        temp = new SpriteSheet(anim[0], 62, 110);
        this.down = new Animation(temp, 180);
        temp = new SpriteSheet(anim[2], 62, 110);
        this.left = new Animation(temp, 180);
        temp = new SpriteSheet(anim[3], 62, 110);
        this.right = new Animation(temp, 180);
        this.up.setPingPong(true);
        this.down.setPingPong(true);
        this.left.setPingPong(true);
        this.right.setPingPong(true);
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        super.update(container, game, delta);
        if (this.charState == GameCharacter.CharacterState.Dead) {
            return;
        }
        Point2D.Float heroPos = ((GamePlay)game.getState(1)).getHero().getPosition();
        switch (this.charState) {
            case Custom: {
                float moveError = 3.0f;
                this.stopMoving(Direction.Up);
                this.stopMoving(Direction.Right);
                if (heroPos.x > this.position.x + moveError) {
                    this.startMoving(Direction.Right);
                } else if (heroPos.x < this.position.x - moveError) {
                    this.startMoving(Direction.Left);
                }
                if (heroPos.y > this.position.y + moveError) {
                    this.startMoving(Direction.Down);
                    break;
                }
                if (!(heroPos.y < this.position.y - moveError)) break;
                this.startMoving(Direction.Up);
            }
        }
    }

    @Override
    public WeaponCollisionData getWeaponCollision() {
        return null;
    }
}

