/*
 * Decompiled with CFR 0.152.
 */
package game.core.mechanics.character;

import game.core.Constants;
import game.core.mechanics.Direction;
import game.core.mechanics.character.Enemy;
import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.collision.WeaponCollisionData;
import game.states.GamePlay;
import java.awt.geom.Point2D;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.geom.Transform;
import org.newdawn.slick.state.StateBasedGame;

public class Dog
extends Enemy {
    private static final int DOG_HEIGHT_FRONT = 80;
    private static final int DOG_WIDTH_FRONT = 62;
    private static final int DOG_HEIGHT_SIDE = 75;
    private static final int DOG_WIDTH_SIDE = 80;
    private static final int DOG_ANIMATIONSPEED_WALK = 180;
    private static final int DOG_ANIMATIONSPEED_JUMP = 180;
    private static final int DOG_ANIMATIONSPEED_GROWL = 80;
    private static final int growlMillis = 300;
    private static final float incrementDivX = 500.0f;
    private static final float incrementDivY = 500.0f;
    private static final int jumpRange = 280;
    private static final int JUMP_PAUSE = 1000;
    private int jumpPause = 0;
    Sound jumpSound;
    Sound barkSound;
    Animation jumpUp = null;
    Animation jumpDown = null;
    Animation jumpLeft = null;
    Animation jumpRight = null;
    Animation growlUp = null;
    Animation growlDown = null;
    Animation growlLeft = null;
    Animation growlRight = null;
    Point2D.Float jumpPosition = new Point2D.Float();
    State currentState = State.Moving;
    float incrementX;
    float incrementY;
    float jumpDistance;
    float currentDistance;
    double jumpTimer;
    private boolean jumping;

    @Override
    public void init(GameContainer container, StateBasedGame game) throws SlickException {
        this.aktHP = this.maxHP = (short)2;
        this.barkSound = new Sound("data/sound/dog_bark.ogg");
        this.collision = new Rectangle(10.0f, 40.0f, 42.0f, 40.0f);
        Image dog = new Image("data/character/dog_normal.png");
        Image[] anim = new Image[4];
        int i = 0;
        while (i < 4) {
            anim[i] = dog.getSubImage(0, i * 80, dog.getWidth(), 80);
            ++i;
        }
        SpriteSheet temp = new SpriteSheet(anim[1], 62, 80);
        this.up = new Animation(temp, 180);
        temp = new SpriteSheet(anim[0], 62, 80);
        this.down = new Animation(temp, 180);
        this.up.setPingPong(true);
        this.down.setPingPong(true);
        temp = new SpriteSheet(anim[3].getSubImage(62, 0, anim[3].getWidth() - 62, 80), 62, 80);
        this.jumpUp = new Animation(temp, 180);
        temp = new SpriteSheet(anim[2].getSubImage(62, 0, anim[2].getWidth() - 62, 80), 62, 80);
        this.jumpDown = new Animation(temp, 180);
        this.jumpUp.setLooping(false);
        this.jumpDown.setLooping(false);
        this.growlUp = new Animation(new Image[]{this.up.getImage(2), anim[3].getSubImage(0, 0, 62, 80)}, 80);
        this.growlDown = new Animation(new Image[]{this.down.getImage(2), anim[2].getSubImage(0, 0, 62, 80)}, 80);
        dog = new Image("data/character/dog_side.png");
        anim = new Image[4];
        int i2 = 0;
        while (i2 < 4) {
            anim[i2] = dog.getSubImage(0, i2 * 75, dog.getWidth(), 75);
            ++i2;
        }
        temp = new SpriteSheet(anim[1], 80, 75);
        this.right = new Animation(temp, 180);
        temp = new SpriteSheet(anim[0], 80, 75);
        this.left = new Animation(temp, 180);
        this.right.setPingPong(true);
        this.left.setPingPong(true);
        temp = new SpriteSheet(anim[3].getSubImage(80, 0, anim[3].getWidth() - 80, 75), 80, 75);
        this.jumpRight = new Animation(temp, 180);
        temp = new SpriteSheet(anim[2].getSubImage(80, 0, anim[2].getWidth() - 80, 75), 80, 75);
        this.jumpLeft = new Animation(temp, 180);
        this.jumpRight.setLooping(false);
        this.jumpLeft.setLooping(false);
        this.growlRight = new Animation(new Image[]{this.right.getImage(2), anim[3].getSubImage(0, 0, 80, 75)}, 80);
        this.growlLeft = new Animation(new Image[]{this.left.getImage(2), anim[2].getSubImage(0, 0, 80, 75)}, 80);
        this.speed = 0.27f;
        this.bodyDamage = 1;
    }

    @Override
    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        super.update(container, game, delta);
        if (this.charState == GameCharacter.CharacterState.Dead) {
            return;
        }
        Point2D.Float heroPos = ((GamePlay)game.getState(1)).getHero().getPosition();
        float distance = (float)Math.sqrt((this.position.x - heroPos.x) * (this.position.x - heroPos.x) + (this.position.y - heroPos.y) * (this.position.y - heroPos.y));
        if (this.charState == GameCharacter.CharacterState.Moving && this.currentState == State.Moving) {
            if (distance <= 280.0f && this.jumpPause <= 0) {
                this.currentState = State.Growling;
                this.barkSound.play();
                this.charState = GameCharacter.CharacterState.Custom;
                this.jumpPosition = (Point2D.Float)this.position.clone();
                this.jumpDistance = 280.0f;
                this.currentDistance = 0.0f;
                this.jumpTimer = 300.0;
                return;
            }
            this.jumpPause -= delta;
        }
        if (this.charState != GameCharacter.CharacterState.Custom) {
            return;
        }
        switch (this.currentState) {
            case Jumping: {
                this.position.x += this.incrementX * (float)delta;
                this.position.y += this.incrementY * (float)delta;
                this.lastMovement.x = this.incrementX * (float)delta;
                this.lastMovement.y = this.incrementY * (float)delta;
                this.currentDistance += Math.abs(this.incrementX * (float)delta) + Math.abs(this.incrementY * (float)delta);
                this.jumpPosition = (Point2D.Float)this.position.clone();
                this.jumpPosition.y = (float)((double)this.jumpPosition.y - Math.sin(Math.PI * (double)(this.currentDistance / this.jumpDistance)) * 50.0);
                if (!(this.currentDistance > this.jumpDistance)) break;
                this.currentState = State.Growling;
                this.jumpTimer = 300.0;
                this.barkSound.play();
                break;
            }
            case Growling: {
                double distX = Math.abs(this.position.x - heroPos.x);
                double distY = Math.abs(this.position.y - heroPos.y);
                double dirHelper = Math.min(distY, distX);
                this.direction = dirHelper == distY ? (this.position.x - heroPos.x < 0.0f ? Direction.Right : Direction.Left) : (this.position.y - heroPos.y < 0.0f ? Direction.Down : Direction.Up);
                this.jumpTimer -= (double)delta;
                if (!(this.jumpTimer <= 0.0)) break;
                if (this.jumping) {
                    this.currentState = State.Moving;
                    this.charState = GameCharacter.CharacterState.Moving;
                    this.jumpPause = 1000;
                    this.jumping = false;
                    break;
                }
                this.jumpUp.restart();
                this.jumpDown.restart();
                this.jumpLeft.restart();
                this.jumpRight.restart();
                this.currentState = State.Jumping;
                this.jumping = true;
                float jumpDistX = heroPos.x - this.position.x;
                float jumpDistY = heroPos.y - this.position.y;
                jumpDistX = 280.0f * jumpDistX / distance;
                jumpDistY = 280.0f * jumpDistY / distance;
                this.incrementX = jumpDistX / 500.0f;
                this.incrementY = jumpDistY / 500.0f;
            }
        }
    }

    @Override
    public void draw(float x, float y) {
        super.draw(x, y);
        if (this.blinking && this.blink > 100) {
            return;
        }
        if (this.charState != GameCharacter.CharacterState.Custom || this.charState == GameCharacter.CharacterState.Dead) {
            return;
        }
        x = this.jumpPosition.x - x - this.getCollisionShape().getCenterX();
        y = this.jumpPosition.y - y - this.getCollisionShape().getCenterY();
        block0 : switch (this.currentState) {
            case Jumping: {
                switch (this.direction) {
                    case Up: {
                        this.jumpUp.draw(x, y);
                        break;
                    }
                    case Down: {
                        this.jumpDown.draw(x, y);
                        break;
                    }
                    case Left: {
                        this.jumpLeft.draw(x, y);
                        break;
                    }
                    case Right: {
                        this.jumpRight.draw(x, y);
                    }
                }
                break;
            }
            case Growling: {
                switch (this.direction) {
                    case Up: {
                        this.growlUp.draw(x, y);
                        break block0;
                    }
                    case Down: {
                        this.growlDown.draw(x, y);
                        break block0;
                    }
                    case Left: {
                        this.growlLeft.draw(x, y);
                        break block0;
                    }
                    case Right: {
                        this.growlRight.draw(x, y);
                    }
                }
            }
        }
    }

    @Override
    public void decreaseHP(int value) {
        if (this.currentState == State.Jumping) {
            return;
        }
        super.decreaseHP(value);
    }

    @Override
    public void pushTo(float driftX, float driftY) {
        if (this.currentState == State.Jumping) {
            return;
        }
        this.currentState = State.Moving;
        this.jumpTimer = 0.0;
        super.pushTo(driftX, driftY);
    }

    @Override
    public WeaponCollisionData getWeaponCollision() {
        return null;
    }

    @Override
    public Shape getNormalCollisionShape() {
        if (this.charState == GameCharacter.CharacterState.Dead) {
            return Constants.EMPTY_COLLISION;
        }
        return this.getCollisionShape().transform(Transform.createTranslateTransform(this.position.x - this.getCollisionShape().getCenterX(), this.position.y - this.getCollisionShape().getCenterY()));
    }

    @Override
    public Shape getCollisionShape() {
        if (this.direction == Direction.Left || this.direction == Direction.Right) {
            return this.collision.transform(Transform.createScaleTransform(1.2903225f, 1.0f));
        }
        return this.collision;
    }

    private static enum State {
        Moving,
        Growling,
        Jumping;

    }
}

