/*
 * Decompiled with CFR 0.152.
 */
package editor.xml;

import editor.xml.IXmlObjectConverter;
import game.core.mechanics.Direction;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.character.BigGuard;
import game.core.mechanics.character.Dog;
import game.core.mechanics.character.Dwarf;
import game.core.mechanics.character.Enemy;
import game.core.mechanics.character.Guard;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConverterEnemy
implements IXmlObjectConverter {
    @Override
    public Class[] getObjectTypes() {
        return new Class[]{Enemy.class, Dog.class, Guard.class, Dwarf.class, BigGuard.class};
    }

    @Override
    public Element getXML(IGameEntity e, Document doc) {
        String type;
        Enemy en = (Enemy)e;
        Element ele = doc.createElement("Enemy");
        ele.setAttribute("x", String.valueOf((int)(e.getPosition().x / 64.0f)));
        ele.setAttribute("y", String.valueOf((int)(e.getPosition().y / 64.0f)));
        ele.setAttribute("direction", String.valueOf((Object)en.getDirection()));
        if (e instanceof Dog) {
            type = "Dog";
        } else if (e instanceof Guard) {
            type = "Guard";
        } else if (e instanceof Dwarf) {
            type = "Dwarf";
        } else if (e instanceof BigGuard) {
            BigGuard g = (BigGuard)e;
            type = "BigGuard";
            ele.setAttribute("areaX", String.valueOf((int)g.getBossArea().getX()));
            ele.setAttribute("areaY", String.valueOf((int)g.getBossArea().getY()));
            ele.setAttribute("dialog", String.valueOf(g.getDialogID()));
        } else {
            return null;
        }
        ele.setAttribute("type", type);
        return ele;
    }

    @Override
    public IGameEntity getObject(Node xml) {
        int x = Integer.parseInt(xml.getAttributes().getNamedItem("x").getNodeValue());
        int y = Integer.parseInt(xml.getAttributes().getNamedItem("y").getNodeValue());
        String type = xml.getAttributes().getNamedItem("type").getNodeValue();
        String dir = xml.getAttributes().getNamedItem("direction").getNodeValue();
        Enemy e = null;
        switch (type) {
            case "Dog": {
                e = new Dog();
                break;
            }
            case "Dwarf": {
                e = new Dwarf();
                break;
            }
            case "Guard": {
                e = new Guard();
                break;
            }
            case "BigGuard": {
                BigGuard g = new BigGuard();
                g.setDialogID(Integer.parseInt(xml.getAttributes().getNamedItem("dialog").getNodeValue()));
                g.getBossArea().setX(Integer.parseInt(xml.getAttributes().getNamedItem("areaX").getNodeValue()));
                g.getBossArea().setY(Integer.parseInt(xml.getAttributes().getNamedItem("areaY").getNodeValue()));
                e = g;
                break;
            }
            default: {
                return null;
            }
        }
        e.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
        switch (dir) {
            case "Up": {
                e.setDirection(Direction.Up);
                break;
            }
            case "Down": {
                e.setDirection(Direction.Down);
                break;
            }
            case "Left": {
                e.setDirection(Direction.Left);
                break;
            }
            case "Right": {
                e.setDirection(Direction.Right);
                break;
            }
            default: {
                e.setDirection(Direction.Down);
            }
        }
        return e;
    }
}

