/*
 * Decompiled with CFR 0.152.
 */
package editor.xml;

import editor.xml.IXmlObjectConverter;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.objects.Destructible;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConverterDestructible
implements IXmlObjectConverter {
    @Override
    public Class[] getObjectTypes() {
        return new Class[]{Destructible.class};
    }

    @Override
    public Element getXML(IGameEntity e, Document doc) {
        Element ele = doc.createElement("Destructible");
        ele.setAttribute("x", String.valueOf((int)(e.getPosition().x / 64.0f)));
        ele.setAttribute("y", String.valueOf((int)(e.getPosition().y / 64.0f)));
        String type = "";
        switch (((Destructible)e).getType()) {
            case Mushroom: {
                type = "Mushroom";
                break;
            }
            case Shrubbery: {
                type = "Shrubbery";
                break;
            }
            case Vase: {
                type = "Vase";
            }
        }
        ele.setAttribute("type", type);
        return ele;
    }

    @Override
    public IGameEntity getObject(Node xml) {
        int x = Integer.parseInt(xml.getAttributes().getNamedItem("x").getNodeValue());
        int y = Integer.parseInt(xml.getAttributes().getNamedItem("y").getNodeValue());
        String type = xml.getAttributes().getNamedItem("type").getNodeValue();
        Destructible d = null;
        switch (type) {
            case "Vase": {
                d = new Destructible(null, Destructible.DestructibleType.Vase);
                break;
            }
            case "Mushroom": {
                d = new Destructible(null, Destructible.DestructibleType.Mushroom);
                break;
            }
            case "Shrubbery": {
                d = new Destructible(null, Destructible.DestructibleType.Shrubbery);
                break;
            }
            default: {
                return null;
            }
        }
        d.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
        return d;
    }
}

