/*
 * Decompiled with CFR 0.152.
 */
package editor.xml;

import editor.xml.IXmlObjectConverter;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.objects.AnimationObject;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConverterAnimation
implements IXmlObjectConverter {
    @Override
    public Element getXML(IGameEntity e, Document doc) {
        Element ele = doc.createElement(AnimationObject.class.getSimpleName());
        ele.setAttribute("x", String.valueOf((int)(e.getPosition().x / 64.0f)));
        ele.setAttribute("y", String.valueOf((int)(e.getPosition().y / 64.0f)));
        String type = ((AnimationObject)e).getObjectType().toString();
        ele.setAttribute("type", type);
        return ele;
    }

    @Override
    public IGameEntity getObject(Node xml) {
        int x = Integer.parseInt(xml.getAttributes().getNamedItem("x").getNodeValue());
        int y = Integer.parseInt(xml.getAttributes().getNamedItem("y").getNodeValue());
        String type = xml.getAttributes().getNamedItem("type").getNodeValue();
        AnimationObject e = null;
        switch (type) {
            case "Torch": {
                e = new AnimationObject(null, AnimationObject.AnimationObjectType.Torch);
                break;
            }
            default: {
                return null;
            }
        }
        e.setPosition(new Point2D.Float(x * 64 + 32, y * 64 + 32));
        return e;
    }

    @Override
    public Class[] getObjectTypes() {
        return new Class[]{AnimationObject.class};
    }
}

