/*
 * Decompiled with CFR 0.152.
 */
package editor;

import game.core.mechanics.Direction;
import game.core.mechanics.IGameEntity;
import game.core.mechanics.character.BigGuard;
import game.core.mechanics.character.Citizen;
import game.core.mechanics.character.GameCharacter;
import game.core.mechanics.objects.Moveable;
import game.core.mechanics.objects.trigger.DialogTrigger;
import game.core.mechanics.objects.trigger.DoorTrigger;
import game.core.mechanics.objects.trigger.OwlTrigger;
import game.core.mechanics.objects.usable.Chest;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.newdawn.slick.SlickException;

public class ObjectPopup
extends JPopupMenu {
    IGameEntity ent;
    ObjectChoise choise = ObjectChoise.Cancel;
    ActionListener callBack;
    ObjectPopup pop;

    public ObjectChoise getChoise() {
        return this.choise;
    }

    public ObjectPopup(IGameEntity entity, ActionListener call) {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ObjectPopup.this.choise = ObjectChoise.Cancel;
                ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
                ObjectPopup.this.choise = ObjectChoise.Cancel;
                ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
            }
        });
        this.ent = entity;
        this.callBack = call;
        this.pop = this;
        JMenuItem mntmDelete = new JMenuItem("Delete");
        mntmDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPopup.this.choise = ObjectChoise.Delete;
                ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
            }
        });
        this.add(mntmDelete);
        JMenuItem mntmMove = new JMenuItem("Move");
        mntmMove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPopup.this.choise = ObjectChoise.Move;
                ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
            }
        });
        this.add(mntmMove);
        JSeparator separator = new JSeparator();
        this.add(separator);
        if (this.ent instanceof Citizen) {
            JMenuItem man = new JMenuItem("Man");
            man.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Citizen e = (Citizen)ObjectPopup.this.ent;
                    e.setCitizenType(1);
                    ObjectPopup.this.choise = ObjectChoise.ChangeCitzen;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            JMenuItem woman = new JMenuItem("Woman");
            woman.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Citizen e = (Citizen)ObjectPopup.this.ent;
                    e.setCitizenType(2);
                    ObjectPopup.this.choise = ObjectChoise.ChangeCitzen;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            JMenuItem child = new JMenuItem("Child");
            child.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Citizen e = (Citizen)ObjectPopup.this.ent;
                    e.setCitizenType(3);
                    ObjectPopup.this.choise = ObjectChoise.ChangeCitzen;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            JMenuItem crippledMan = new JMenuItem("Crippled Man");
            crippledMan.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Citizen e = (Citizen)ObjectPopup.this.ent;
                    e.setCitizenType(4);
                    ObjectPopup.this.choise = ObjectChoise.ChangeCitzen;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            JMenu changeCit = new JMenu("Change Citizen");
            changeCit.add(man);
            changeCit.add(woman);
            changeCit.add(child);
            changeCit.add(crippledMan);
            this.add(changeCit);
        }
        if (this.ent instanceof GameCharacter) {
            JMenuItem up = new JMenuItem("Up");
            up.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GameCharacter e = (GameCharacter)ObjectPopup.this.ent;
                    e.setDirection(Direction.Up);
                    ObjectPopup.this.choise = ObjectChoise.ChangeDirection;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            JMenuItem down = new JMenuItem("Down");
            down.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GameCharacter e = (GameCharacter)ObjectPopup.this.ent;
                    e.setDirection(Direction.Down);
                    ObjectPopup.this.choise = ObjectChoise.ChangeDirection;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            JMenuItem left = new JMenuItem("Left");
            left.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GameCharacter e = (GameCharacter)ObjectPopup.this.ent;
                    e.setDirection(Direction.Left);
                    ObjectPopup.this.choise = ObjectChoise.ChangeDirection;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            JMenuItem right = new JMenuItem("Right");
            right.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GameCharacter e = (GameCharacter)ObjectPopup.this.ent;
                    e.setDirection(Direction.Right);
                    ObjectPopup.this.choise = ObjectChoise.ChangeDirection;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            JMenu changeDir = new JMenu("Change Direction");
            changeDir.add(up);
            changeDir.add(down);
            changeDir.add(left);
            changeDir.add(right);
            this.add(changeDir);
        }
        if (entity instanceof DoorTrigger) {
            JMenu doorType = new JMenu("Change Doortype");
            JMenuItem wood = new JMenuItem("Wood");
            wood.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent eArgs) {
                    DoorTrigger e = (DoorTrigger)ObjectPopup.this.ent;
                    e.setDoorType(DoorTrigger.Type.Wood);
                    try {
                        e.init(null, null);
                    }
                    catch (SlickException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            JMenuItem castle = new JMenuItem("Castle");
            castle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent eArgs) {
                    DoorTrigger e = (DoorTrigger)ObjectPopup.this.ent;
                    e.setDoorType(DoorTrigger.Type.Castle);
                    try {
                        e.init(null, null);
                    }
                    catch (SlickException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            doorType.add(wood);
            doorType.add(castle);
            this.add(doorType);
        }
        if (entity instanceof Chest) {
            JMenuItem key = new JMenuItem("Key");
            key.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Chest c = (Chest)ObjectPopup.this.ent;
                    c.setItem(Chest.Item.Key);
                    ObjectPopup.this.choise = ObjectChoise.ChangeContent;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            JMenuItem potion = new JMenuItem("Potion");
            potion.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Chest c = (Chest)ObjectPopup.this.ent;
                    c.setItem(Chest.Item.Potion);
                    ObjectPopup.this.choise = ObjectChoise.ChangeContent;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            JMenuItem heart = new JMenuItem("Heart");
            heart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Chest c = (Chest)ObjectPopup.this.ent;
                    c.setItem(Chest.Item.Heart);
                    ObjectPopup.this.choise = ObjectChoise.ChangeContent;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            JMenu changeContent = new JMenu("Change Content");
            changeContent.add(key);
            changeContent.add(potion);
            changeContent.add(heart);
            this.add(changeContent);
        }
        if (entity instanceof Moveable) {
            ActionListener mov = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int movRate = -1;
                    switch (e.getActionCommand()) {
                        case "1": {
                            movRate = 1;
                            break;
                        }
                        case "2": {
                            movRate = 2;
                            break;
                        }
                        case "3": {
                            movRate = 3;
                            break;
                        }
                        case "4": {
                            movRate = 4;
                            break;
                        }
                        default: {
                            movRate = -1;
                        }
                    }
                    Moveable m = (Moveable)ObjectPopup.this.ent;
                    m.setMaxMove(movRate);
                    ObjectPopup.this.choise = ObjectChoise.ChangeMovementRate;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            };
            JMenuItem one = new JMenuItem("1");
            one.addActionListener(mov);
            JMenuItem two = new JMenuItem("2");
            two.addActionListener(mov);
            JMenuItem three = new JMenuItem("3");
            three.addActionListener(mov);
            JMenuItem four = new JMenuItem("4");
            four.addActionListener(mov);
            JMenuItem inf = new JMenuItem("Infinite");
            inf.addActionListener(mov);
            JMenu changeMov = new JMenu("Change Movementrange");
            changeMov.add(one);
            changeMov.add(two);
            changeMov.add(three);
            changeMov.add(four);
            changeMov.add(inf);
            this.add(changeMov);
        }
        if (entity instanceof DialogTrigger || entity instanceof OwlTrigger || entity instanceof Citizen || entity instanceof BigGuard) {
            JMenuItem changeDialog = new JMenuItem("Change Dialog");
            changeDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjectPopup.this.choise = ObjectChoise.ChangeDialog;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            this.add(changeDialog);
        }
        if (entity instanceof OwlTrigger) {
            JMenuItem changeOwl = new JMenuItem("Change Owl Position");
            changeOwl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ObjectPopup.this.choise = ObjectChoise.ChangeOwlPosition;
                    ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
                }
            });
            this.add(changeOwl);
        }
        this.add(new JSeparator());
        JMenuItem menuItem = new JMenuItem("Cancel");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPopup.this.choise = ObjectChoise.Cancel;
                ObjectPopup.this.callBack.actionPerformed(new ActionEvent(ObjectPopup.this.pop, 0, ""));
            }
        });
        this.add(menuItem);
    }

    public static enum ObjectChoise {
        Delete,
        Move,
        ChangeDirection,
        ChangeContent,
        ChangeDialog,
        ChangeOwlPosition,
        ChangeMovementRate,
        ChangeCitzen,
        Cancel;

    }
}

